/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.formbuilder.FormCopier;
import com.arsdigita.cms.formbuilder.NoParametersHttpServletRequest;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.formbuilder.ComponentAddObserver;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.ui.BaseAddObserver;
import com.arsdigita.formbuilder.ui.ComponentTraverse;
import com.arsdigita.formbuilder.ui.FormBuilderXMLRenderer;
import com.arsdigita.formbuilder.ui.PlaceholdersInitListener;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class FormSectionItem
extends ContentPage
implements XMLGenerator {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.formbuilder.FormSectionItem";
    public static final String FORM_SECTION = "formSection";

    public FormSectionItem() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public FormSectionItem(String typeName) {
        super(typeName);
    }

    public FormSectionItem(DataObject obj) {
        super(obj);
    }

    public FormSectionItem(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public FormSectionItem(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void beforeSave() {
        if (this.isNew() && this.get(FORM_SECTION) == null) {
            PersistentFormSection formSection = new PersistentFormSection();
            formSection.setAdminName(this.getName());
            formSection.save();
            this.setAssociation(FORM_SECTION, (DomainObject)formSection);
        }
        super.beforeSave();
    }

    public void delete() {
        PersistentFormSection form = this.getFormSection();
        Collection children = form.getComponents();
        form.clearComponents();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            PersistentComponentFactory c = (PersistentComponentFactory)i.next();
            c.delete();
        }
        super.delete();
        form.delete();
    }

    public boolean copyProperty(CustomCopy src, Property property, ItemCopier copier) {
        if (property.getName().equals(FORM_SECTION)) {
            this.setAssociation(FORM_SECTION, (DomainObject)new FormCopier().copyFormSection(((FormSectionItem)src).getFormSection()));
            return true;
        }
        return super.copyProperty(src, property, copier);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PersistentFormSection getFormSection() {
        return new PersistentFormSection((DataObject)this.get(FORM_SECTION));
    }

    public void generateXML(PageState state, Element parent, String useContext) {
        PageState fake;
        PersistentFormSection form = this.getFormSection();
        form.setComponentAddObserver((ComponentAddObserver)new BaseAddObserver());
        Form c = new Form("formSectionItem");
        c.add((Component)((FormSection)form.createComponent()));
        c.addInitListener((FormInitListener)new PlaceholdersInitListener());
        Traversal t = new Traversal(){

            public void act(Component c) {
                try {
                    Widget widget = (Widget)c;
                    widget.setDisabled();
                    widget.setReadOnly();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        };
        t.preorder((Component)c);
        Page p = new Page("dummy");
        p.add((Component)c);
        p.lock();
        try {
            fake = p.process((HttpServletRequest)new NoParametersHttpServletRequest(state.getRequest()), state.getResponse());
        }
        catch (Exception e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        VisibleTraverse t2 = new VisibleTraverse(fake);
        t2.preorder((Component)c);
        Element element = parent.newChildElement("cms:item", "http://www.arsdigita.com/cms/1.0");
        String action = c.getAction();
        if (action == null) {
            URL requestURL = Web.getContext().getRequestURL();
            action = requestURL == null ? state.getRequest().getRequestURI() : requestURL.getRequestURI();
        }
        element.addAttribute("formAction", action);
        FormBuilderXMLRenderer renderer = new FormBuilderXMLRenderer(element);
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        renderer.walk((DomainObject)this, SimpleXMLGenerator.ADAPTER_CONTEXT);
        state.generateXML(element.newChildElement("cms:pageState", "http://www.arsdigita.com/cms/1.0"));
        if (c instanceof Form) {
            Element infoElement = element.newChildElement("formbuilder:formInfo", "http://www.arsdigita.com/formbuilder/1.0");
            Form f = c;
            ComponentTraverse infoTraversal = new ComponentTraverse(state, c.getFormData(state), infoElement);
            infoTraversal.preorder((Component)f);
        }
        fake.setControlEvent((Component)c);
        fake.generateXML(element.newChildElement("formbuilder:pageState", "http://www.arsdigita.com/formbuilder/1.0"));
    }

    private class VisibleTraverse
    extends Traversal {
        PageState m_state;

        VisibleTraverse(PageState state) {
            this.m_state = state;
        }

        public void act(Component c) {
            try {
                this.m_state.setVisible(c, true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

