/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.formbuilder;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.xml.Element;


public class XMLGenerator extends SimpleXMLGenerator {

    public void generateXML(PageState state,
                            Element parent,
                            String useContext) {
        ContentItem item = getContentItem(state);

        try {
            // XXX bad OO access to parent attribute
            String defClass = (String)item.get("defaultDomainClass");
            if (!item.getClass().getName().equals(defClass)) {
                item = (ContentItem)FormBuilderUtil.instantiateObjectOneArg(defClass, item.getID());
            }

            com.arsdigita.cms.dispatcher.XMLGenerator generator =
                (com.arsdigita.cms.dispatcher.XMLGenerator)item;

            generator.generateXML(state, parent, useContext);
        } catch (ClassCastException ex) {
            super.generateXML(state, parent, useContext);
        }
    }
}
