/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.formbuilder;

import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.formbuilder.FormSectionItem;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;




public class FormSectionModelBuilder implements PrintListener {
    private ItemSelectionModel m_item;

    public FormSectionModelBuilder(ItemSelectionModel item) {
        m_item = item;
    }

    public void prepare(PrintEvent e) {
        ContentItem item = (ContentItem)m_item.getSelectedObject(e.getPageState());
        ContentSection section = item.getContentSection();
        
        Session session = SessionManager.getSession();
        DataCollection sections = session.retrieve(FormSectionItem.BASE_DATA_OBJECT_TYPE);
        sections.addEqualsFilter(ContentItem.VERSION, ContentItem.DRAFT);
        sections.addOrder(ContentPage.TITLE);

        OptionGroup group = (OptionGroup)e.getTarget();

        while (sections.next()) {
            DataObject obj = sections.getDataObject();
            
            group.addOption(new Option(obj.get(ContentItem.ID).toString(), 
                                       obj.get(ContentPage.TITLE).toString()));
        }
    }
}
