/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.formbuilder.FormSectionItem;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class FormSectionProperties
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public FormSectionProperties(ItemSelectionModel model, AuthoringKitWizard parent) {
        super(model, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        FormSectionPropertyEditForm edit = new FormSectionPropertyEditForm(model, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)edit, model), edit.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(this.buildDisplayComponent(model));
    }

    private Component buildDisplayComponent(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.name"), "name");
        sheet.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.title"), "title");
        sheet.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.description"), "form", (DomainObjectPropertySheet.AttributeFormatter)new FormSectionFormatter());
        return sheet;
    }

    private class FormSectionFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        ItemSelectionModel m_item;

        private FormSectionFormatter() {
        }

        public String format(DomainObject item, String attribute, PageState state) {
            if (attribute.equals("form")) {
                FormSectionItem section = (FormSectionItem)item;
                PersistentFormSection s = section.getFormSection();
                return s.getDescription();
            }
            return null;
        }
    }

    protected class FormSectionPropertyEditForm
    extends BasicPageForm
    implements FormProcessListener,
    FormInitListener,
    FormSubmissionListener {
        private FormSectionProperties m_step;
        private TextArea m_desc;

        public FormSectionPropertyEditForm(ItemSelectionModel itemModel) {
            this(itemModel, null);
        }

        public FormSectionPropertyEditForm(ItemSelectionModel itemModel, FormSectionProperties sectionProperties) {
            super("edit_properties", itemModel);
            this.m_step = sectionProperties;
            this.addSubmissionListener(this);
        }

        protected void addWidgets() {
            super.addWidgets();
            this.m_desc = new TextArea((ParameterModel)new StringParameter("description"));
            this.m_desc.setRows(5);
            this.m_desc.setCols(50);
            this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.description")));
            this.add((Component)this.m_desc);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            FormSectionItem item = (FormSectionItem)this.initBasicWidgets(e);
            PersistentFormSection form = item.getFormSection();
            this.m_desc.setValue(e.getPageState(), (Object)form.getDescription());
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            FormSectionItem item = (FormSectionItem)this.processBasicWidgets(e);
            PersistentFormSection form = item.getFormSection();
            item.save();
            form.setAdminName(item.getName());
            form.setDescription((String)data.get((Object)"description"));
            form.save();
            if (this.m_step != null) {
                this.m_step.maybeForwardToNextStep(e.getPageState());
            }
        }

        public void submitted(FormSectionEvent fse) {
            if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
                this.m_step.cancelStreamlinedCreation(fse.getPageState());
            }
        }
    }
}

