/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.cms.formbuilder.FormSectionItem;
import com.arsdigita.cms.formbuilder.FormUnavailableException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.ComponentAddObserver;
import com.arsdigita.formbuilder.CompoundComponent;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FormSectionWrapper
extends PersistentComponent
implements CompoundComponent {
    public static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$formbuilder$FormSectionWrapper == null ? (class$com$arsdigita$cms$formbuilder$FormSectionWrapper = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionWrapper")) : class$com$arsdigita$cms$formbuilder$FormSectionWrapper));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.formbuilder.FormSectionWrapper";
    public static final String FORM_SECTION_ITEM = "formSectionItem";
    public static final String VERSION = "version";
    private ComponentAddObserver m_addObserver = null;
    static /* synthetic */ Class class$com$arsdigita$cms$formbuilder$FormSectionWrapper;
    static /* synthetic */ Class class$com$arsdigita$cms$formbuilder$FormSectionItem;

    public FormSectionWrapper() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public FormSectionWrapper(String typeName) {
        super(typeName);
    }

    public FormSectionWrapper(DataObject obj) {
        super(obj);
    }

    public FormSectionWrapper(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public FormSectionWrapper(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static FormSectionWrapper create(FormSectionItem item, String version) {
        FormSectionWrapper wrapper = new FormSectionWrapper();
        wrapper.setFormSectionItem(item);
        wrapper.setVersion(version);
        return wrapper;
    }

    public void setVersion(String version) {
        this.set(VERSION, version);
    }

    public String getVersion() {
        return (String)this.get(VERSION);
    }

    public void setFormSectionItem(FormSectionItem item) {
        Assert.truth((boolean)"draft".equals(item.getVersion()), (String)"item is draft");
        this.setAssociation(FORM_SECTION_ITEM, (DomainObject)item);
    }

    public FormSectionItem getFormSectionItem() {
        return (FormSectionItem)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(FORM_SECTION_ITEM)));
    }

    public void setComponentAddObserver(ComponentAddObserver observer) {
        this.m_addObserver = observer;
    }

    public Component createComponent() {
        FormSectionItem item = this.getFormSectionItem();
        if (item == null) {
            throw new FormUnavailableException("Form section item is missing");
        }
        if ("live".equals(this.getVersion())) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Looking for live version of form");
            }
            if ((item = (FormSectionItem)item.getLiveVersion()) == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.info((Object)"No live version found");
                }
                throw new FormUnavailableException("Form section is not live");
            }
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using form item " + item.getOID()));
        }
        PersistentFormSection section = item.getFormSection();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using form section " + section.getOID()));
        }
        if (this.m_addObserver != null) {
            section.setComponentAddObserver(this.m_addObserver);
        }
        return section.createComponent();
    }

    public void addComponent(PersistentComponentFactory componentFactory) {
        FormSectionItem item = this.getFormSectionItem();
        Assert.exists((Object)((Object)item), (Class)(class$com$arsdigita$cms$formbuilder$FormSectionItem == null ? (class$com$arsdigita$cms$formbuilder$FormSectionItem = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionItem")) : class$com$arsdigita$cms$formbuilder$FormSectionItem));
        item.getFormSection().addComponent(componentFactory);
    }

    public void addComponent(PersistentComponentFactory componentFactory, int position) {
        FormSectionItem item = this.getFormSectionItem();
        Assert.exists((Object)((Object)item), (Class)(class$com$arsdigita$cms$formbuilder$FormSectionItem == null ? (class$com$arsdigita$cms$formbuilder$FormSectionItem = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionItem")) : class$com$arsdigita$cms$formbuilder$FormSectionItem));
        item.getFormSection().addComponent(componentFactory, position);
    }

    public void removeComponent(PersistentComponentFactory componentFactory) {
        FormSectionItem item = this.getFormSectionItem();
        Assert.exists((Object)((Object)item), (Class)(class$com$arsdigita$cms$formbuilder$FormSectionItem == null ? (class$com$arsdigita$cms$formbuilder$FormSectionItem = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionItem")) : class$com$arsdigita$cms$formbuilder$FormSectionItem));
        item.getFormSection().removeComponent(componentFactory);
    }

    public void moveComponent(PersistentComponentFactory componentFactory, int toPosition) {
        FormSectionItem item = this.getFormSectionItem();
        Assert.exists((Object)((Object)item), (Class)(class$com$arsdigita$cms$formbuilder$FormSectionItem == null ? (class$com$arsdigita$cms$formbuilder$FormSectionItem = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionItem")) : class$com$arsdigita$cms$formbuilder$FormSectionItem));
        item.getFormSection().moveComponent(componentFactory, toPosition);
    }

    public void clearComponents() {
        FormSectionItem item = this.getFormSectionItem();
        Assert.exists((Object)((Object)item), (Class)(class$com$arsdigita$cms$formbuilder$FormSectionItem == null ? (class$com$arsdigita$cms$formbuilder$FormSectionItem = FormSectionWrapper.class$("com.arsdigita.cms.formbuilder.FormSectionItem")) : class$com$arsdigita$cms$formbuilder$FormSectionItem));
        item.getFormSection().clearComponents();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

