/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.formbuilder;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;
import com.arsdigita.formbuilder.ui.ControlEditor;


public class FormSectionControls extends ControlEditor {

    private ItemSelectionModel m_itemModel;

    public FormSectionControls(ItemSelectionModel item,
                               AuthoringKitWizard parent) {

        super("forms-cms",
              new FormSectionSingleSelectionModel(item));

        m_itemModel = item;
    }

    protected void addEditableComponent(Container container,
                                        Component child) {
        WorkflowLockedContainer lock = new WorkflowLockedContainer(((FormSectionSingleSelectionModel)getFormModel()).getItemModel());
        lock.add(child);
        super.addEditableComponent(container, lock);
    }

    protected boolean addItemEditObserver(PageState state) {
        return Utilities.getSecurityManager(state).canAccess(
            state.getRequest(),
            SecurityManager.EDIT_ITEM,
            (ContentItem) m_itemModel.getSelectedObject(state));
    }
}
