/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.web.HttpServletRequestWrapper;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Map;

class NoParametersHttpServletRequest extends HttpServletRequestWrapper {
    public NoParametersHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration getParameterNames() {
        return new Enumeration() {
                public Object nextElement() {
                    return null;
                }

                public boolean hasMoreElements() {
                    return false;
                }
            };
    }

    public Map getParameterMap() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String[] getParameterValues(String name) {
        return null;
    }
}
