/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.formbuilder;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.formbuilder.FormSectionItem;
import com.arsdigita.cms.formbuilder.FormSectionWrapper;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.ui.ControlEditor;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;

import java.math.BigDecimal;

public class FormControls extends ControlEditor {
    private ItemSelectionModel m_itemModel;

    public FormControls(ItemSelectionModel item,
                        AuthoringKitWizard parent) {
        super("forms-cms",
              new FormSingleSelectionModel(item), true);

        m_itemModel = item;
        
        setFormSectionModelBuilder(new FormSectionModelBuilder(item));
    }

    protected void addEditableComponent(Container container,
                                        Component child) {
        WorkflowLockedContainer lock = new WorkflowLockedContainer(((FormSingleSelectionModel)getFormModel()).getItemModel());
        lock.add(child);
        super.addEditableComponent(container, lock);
    }

    protected PersistentComponentFactory getFormSection(PageState state,
                                                        BigDecimal sectionID) {        
        FormSectionItem section = null;
        try {
            section = (FormSectionItem)DomainObjectFactory.newInstance(
                new OID(FormSectionItem.BASE_DATA_OBJECT_TYPE,
                        sectionID));
        } catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot load section", ex);
        }
        
        FormSectionWrapper wrapper = FormSectionWrapper.create(section,
                                                               ContentItem.DRAFT);
        
        return wrapper;
    }
    
    
    protected boolean addItemEditObserver(PageState state) {
        return Utilities.getSecurityManager(state).canAccess(
            state.getRequest(),
            SecurityManager.EDIT_ITEM,
            (ContentItem) m_itemModel.getSelectedObject(state));
    }
}
