/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.contenttypes.AbstractContentTypeLoader;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;

import java.util.ArrayList;
import java.util.List;

/**
 * Loader
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 **/

public class FormItemLoader extends AbstractContentTypeLoader {

    public final static String versionId = "$Id: //cms/content-types/formitem/dev/src/com/arsdigita/cms/formbuilder/FormItemLoader.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final Parameter m_contentSections = new StringParameter
        ("com.arsdigita.cms.formbuilder.FormItem.sections",
         Parameter.REQUIRED, "forms");

    {
        register(m_contentSections);
        loadInfo();
    }

    private static final String[] TYPES = {
        "/WEB-INF/content-types/com/arsdigita/cms/formbuilder/FormItem.xml"
    };

    public String[] getTypes() {
        return TYPES;
    }

    public List getContentSections() {
        List result = new ArrayList(1);
        result.add(get(m_contentSections));
        return result;
    }
}
