/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.ContentTypeInitializer;

import org.apache.log4j.Logger;

/**
 * Initializer
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

public class FormItemInitializer extends ContentTypeInitializer {

    private static final Logger s_log = 
        Logger.getLogger(FormItemInitializer.class);

    public FormItemInitializer() {
        super("ccm-cms-types-formitem.pdl.mf",
              FormItem.BASE_DATA_OBJECT_TYPE);
    }

    public String getTraversalXML() {
        return "WEB-INF/traversal-adapters/com/arsdigita/" +
            "cms/formbuilder/FormItem.xml";
    }

    public String[] getStylesheets() {
        return new String[] { 
            "/static/content-types/com/arsdigita/" + 
            "cms/contenttypes/FormItem.xsl" 
        };
    }
}
