/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.formbuilder.FormItem;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class FormProperties
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public FormProperties(ItemSelectionModel model, AuthoringKitWizard parent) {
        super(model, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        BasicPageForm editForm = this.buildEditForm(model);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editForm, model), editForm.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(this.buildDisplayComponent(model));
    }

    protected BasicPageForm buildEditForm(ItemSelectionModel model) {
        return new FormPropertyEditForm(model, this);
    }

    protected Component buildDisplayComponent(ItemSelectionModel model) {
        return new FormPropertySheet(model);
    }

    private class FormFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        ItemSelectionModel m_item;

        private FormFormatter() {
        }

        public String format(DomainObject item, String attribute, PageState state) {
            if (attribute.equals("form")) {
                FormItem formitem = (FormItem)item;
                PersistentForm f = formitem.getForm();
                return f.getDescription();
            }
            return null;
        }
    }

    protected class FormPropertySheet
    extends DomainObjectPropertySheet {
        public FormPropertySheet(ItemSelectionModel model) {
            super((DomainObjectSelectionModel)model);
            this.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.name"), "name");
            this.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.title"), "title");
            this.add(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.description"), "form", new FormFormatter());
            this.add(GlobalizationUtil.globalize((String)"cms.formbuilder.css"), "css");
        }
    }

    protected class FormPropertyEditForm
    extends BasicPageForm
    implements FormProcessListener,
    FormInitListener,
    FormSubmissionListener {
        private TextArea m_desc;
        private TextField m_css;
        private FormProperties m_step;

        public FormPropertyEditForm(ItemSelectionModel itemModel) {
            this(itemModel, null);
        }

        public FormPropertyEditForm(ItemSelectionModel itemModel, FormProperties formProperties) {
            super("edit_properties", itemModel);
            this.m_step = formProperties;
            this.addSubmissionListener(this);
        }

        protected void addWidgets() {
            super.addWidgets();
            this.m_desc = new TextArea((ParameterModel)new StringParameter("description"));
            this.m_desc.setRows(5);
            this.m_desc.setCols(50);
            this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.ui.formbuilder.description")));
            this.add((Component)this.m_desc);
            this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.formbuilder.css")));
            this.m_css = new TextField((ParameterModel)new StringParameter("css"));
            this.add((Component)this.m_css);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            FormItem item = (FormItem)this.initBasicWidgets(e);
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormItem item = (FormItem)this.processBasicWidgets(e);
            item.save();
            if (this.m_step != null) {
                this.m_step.maybeForwardToNextStep(e.getPageState());
            }
        }

        public ContentPage initBasicWidgets(FormSectionEvent e) {
            FormItem item = (FormItem)super.initBasicWidgets(e);
            PersistentForm form = item.getForm();
            this.m_desc.setValue(e.getPageState(), (Object)form.getDescription());
            this.m_css.setValue(e.getPageState(), (Object)item.getCSS());
            return item;
        }

        public ContentPage processBasicWidgets(FormSectionEvent e) {
            FormItem item = (FormItem)super.processBasicWidgets(e);
            PersistentForm form = item.getForm();
            item.setCSS((String)this.m_css.getValue(e.getPageState()));
            item.save();
            form.setAdminName(item.getName());
            form.setHTMLName(item.getName());
            form.setDescription((String)this.m_desc.getValue(e.getPageState()));
            form.save();
            return item;
        }

        public void submitted(FormSectionEvent fse) {
            if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
                this.m_step.cancelStreamlinedCreation(fse.getPageState());
            }
        }
    }
}

