/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.formbuilder.FormSectionItem;
import com.arsdigita.cms.formbuilder.FormSectionWrapper;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.formbuilder.FormSectionModelBuilder;
import com.arsdigita.cms.ui.formbuilder.FormSingleSelectionModel;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.ui.ControlEditor;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class FormControls
extends ControlEditor {
    private ItemSelectionModel m_itemModel;

    public FormControls(ItemSelectionModel item, AuthoringKitWizard parent) {
        super("forms-cms", (SingleSelectionModel)new FormSingleSelectionModel(item), true);
        this.m_itemModel = item;
        this.setFormSectionModelBuilder((PrintListener)new FormSectionModelBuilder(item));
    }

    protected void addEditableComponent(Container container, Component child) {
        WorkflowLockedContainer lock = new WorkflowLockedContainer(((FormSingleSelectionModel)this.getFormModel()).getItemModel());
        lock.add(child);
        super.addEditableComponent(container, (Component)lock);
    }

    protected PersistentComponentFactory getFormSection(PageState state, BigDecimal sectionID) {
        FormSectionItem section = null;
        try {
            section = (FormSectionItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.formbuilder.FormSectionItem", (Object)sectionID));
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot load section", (Throwable)ex);
        }
        FormSectionWrapper wrapper = FormSectionWrapper.create((FormSectionItem)section, (String)"draft");
        return wrapper;
    }

    protected boolean addItemEditObserver(PageState state) {
        return Utilities.getSecurityManager((PageState)state).canAccess(state.getRequest(), "edit_item", (ContentItem)this.m_itemModel.getSelectedObject(state));
    }
}

