/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.formbuilder.FormCopier;
import com.arsdigita.cms.formbuilder.FormUnavailableException;
import com.arsdigita.cms.formbuilder.NoParametersHttpServletRequest;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.formbuilder.ComponentAddObserver;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.ui.BaseAddObserver;
import com.arsdigita.formbuilder.ui.ComponentTraverse;
import com.arsdigita.formbuilder.ui.FormBuilderXMLRenderer;
import com.arsdigita.formbuilder.ui.PlaceholdersInitListener;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class FormItem
extends ContentPage
implements XMLGenerator {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.formbuilder.FormItem";
    public static final String FORM = "form";
    public static final String CSS = "css";

    public FormItem() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public FormItem(String typeName) {
        super(typeName);
    }

    public FormItem(DataObject obj) {
        super(obj);
    }

    public FormItem(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public FormItem(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void beforeSave() {
        if (this.isNew() && this.get(FORM) == null) {
            PersistentForm form = new PersistentForm();
            form.setHTMLName(this.getName());
            form.setAdminName(this.getName());
            this.setAssociation(FORM, (DomainObject)form);
        }
        super.beforeSave();
    }

    public void delete() {
        PersistentForm form = this.getForm();
        Collection children = form.getComponents();
        form.clearComponents();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            PersistentComponentFactory c = (PersistentComponentFactory)i.next();
            if (c instanceof PersistentFormSection) {
                if ("draft".equals(this.getVersion())) continue;
                this.deleteSection((PersistentFormSection)c);
                continue;
            }
            c.delete();
        }
        super.delete();
        form.delete();
    }

    private void deleteSection(PersistentFormSection form) {
        Collection children = form.getComponents();
        form.clearComponents();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            PersistentComponentFactory c = (PersistentComponentFactory)i.next();
            c.delete();
        }
        form.delete();
    }

    public boolean copyProperty(CustomCopy src, Property property, ItemCopier copier) {
        if (property.getName().equals(FORM)) {
            this.setAssociation(FORM, (DomainObject)new FormCopier().copyForm(((FormItem)src).getForm()));
            return true;
        }
        return super.copyProperty(src, property, copier);
    }

    public static FormItem getItemByName(Folder folder, String name) throws DataObjectNotFoundException {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter("parent", (Object)folder.getID());
        types.addEqualsFilter("name", (Object)name);
        if (types.next()) {
            DataObject obj = types.getDataObject();
            FormItem f = new FormItem(obj);
            types.close();
            return f;
        }
        throw new DataObjectNotFoundException((String)GlobalizationUtil.globalize((String)"cms.formbuilder.no_such_form").localize());
    }

    public PersistentForm getForm() {
        return new PersistentForm((DataObject)this.get(FORM));
    }

    public void setCSS(String css) {
        this.set(CSS, css);
    }

    public String getCSS() {
        return (String)this.get(CSS);
    }

    protected Form instantiateForm(PersistentForm form, boolean readOnly) {
        form.setComponentAddObserver((ComponentAddObserver)new BaseAddObserver());
        Form c = (Form)form.createComponent();
        c.addInitListener((FormInitListener)new PlaceholdersInitListener());
        c.setMethod("get");
        if (readOnly) {
            Traversal t = new Traversal(){

                public void act(Component c) {
                    try {
                        Widget widget = (Widget)c;
                        widget.setDisabled();
                        widget.setReadOnly();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            };
            t.preorder((Component)c);
        }
        return c;
    }

    public void generateXML(PageState state, Element parent, String useContext) {
        PageState fake;
        PersistentForm form = this.getForm();
        Form c = null;
        try {
            c = this.instantiateForm(form, "itemAdminSummary".equals(useContext));
        }
        catch (FormUnavailableException ex) {
            c = new Label("This form is temporarily unavailable");
        }
        Page p = new Page("dummy");
        p.add((Component)c);
        p.lock();
        try {
            fake = "itemAdminSummary".equals(useContext) ? p.process((HttpServletRequest)new NoParametersHttpServletRequest(state.getRequest()), state.getResponse()) : p.process(state.getRequest(), state.getResponse());
        }
        catch (Exception e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        VisibleTraverse t = new VisibleTraverse(fake);
        t.preorder((Component)c);
        Element element = parent.newChildElement("cms:item", "http://www.arsdigita.com/cms/1.0");
        this.generateXMLBody(fake, element, (Component)c);
        String action = form.getAction();
        if (action == null) {
            URL requestURL = Web.getContext().getRequestURL();
            action = requestURL == null ? state.getRequest().getRequestURI() : requestURL.getRequestURI();
        }
        element.addAttribute("formAction", action);
        FormBuilderXMLRenderer renderer = new FormBuilderXMLRenderer(element);
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        renderer.walk((DomainObject)this, SimpleXMLGenerator.ADAPTER_CONTEXT);
        if (c instanceof Form) {
            Element infoElement = element.newChildElement("formbuilder:formInfo", "http://www.arsdigita.com/formbuilder/1.0");
            Form f = c;
            ComponentTraverse infoTraversal = new ComponentTraverse(state, c.getFormData(state), infoElement);
            infoTraversal.preorder((Component)f);
        }
        fake.setControlEvent((Component)c);
        fake.generateXML(element.newChildElement("formbuilder:pageState", "http://www.arsdigita.com/formbuilder/1.0"));
    }

    protected void generateXMLBody(PageState state, Element parent, Component c) {
    }

    private class VisibleTraverse
    extends Traversal {
        PageState m_state;

        VisibleTraverse(PageState state) {
            this.m_state = state;
        }

        public void act(Component c) {
            try {
                this.m_state.setVisible(c, true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

