/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.formbuilder;


import com.arsdigita.bebop.AbstractSingleSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.formbuilder.FormItem;
import com.arsdigita.cms.util.GlobalizationUtil;


public class FormSingleSelectionModel extends AbstractSingleSelectionModel {

    private ItemSelectionModel m_item;

    public FormSingleSelectionModel(ItemSelectionModel item) {
        m_item = item;
    }

    public ItemSelectionModel getItemModel() {
        return m_item;
    }

    public boolean isSelected(PageState state) {
        return m_item.isSelected(state);
    }

    public Object getSelectedKey(PageState state) {
        FormItem item = (FormItem)m_item.getSelectedObject(state);
        return item.getForm().getID();
    }

    public void setSelectedKey(PageState state,
                               Object key) {
        throw new RuntimeException( (String) GlobalizationUtil.globalize("cms.ui.formbuilder.oh_no_you_dont").localize());
    }

    public void clearSelection(PageState state) {
        throw new RuntimeException( (String) GlobalizationUtil.globalize("cms.ui.formbuilder.oh_no_you_dont").localize());
    }

    public void addChangeListener(ChangeListener l) {
        throw new RuntimeException( (String) GlobalizationUtil.globalize("cms.ui.formbuilder.oh_no_you_dont").localize());
    }

    public void removeChangeListener(ChangeListener l) {
        throw new RuntimeException( (String) GlobalizationUtil.globalize("cms.ui.formbuilder.oh_no_you_dont").localize());
    }

    public ParameterModel getStateParameter() {
        throw new RuntimeException( (String) GlobalizationUtil.globalize("cms.ui.formbuilder.oh_no_you_dont").localize());
    }
}
