/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.FileStorageItem;
import com.arsdigita.cms.contenttypes.ui.authoring.FileStorageItemPropertiesStep;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicPageForm;


/**
 * Form to edit the basic properties of an FileStorageItem. This form can be
 * extended to create forms for FileStorageItem subclasses.
 */
public class FileStorageItemPropertyForm
    extends BasicPageForm
    implements FormProcessListener, FormInitListener, FormSubmissionListener {


    private FileStorageItemPropertiesStep m_step;

    /** Name of this form */
    public static final String ID = "FileStorageItem_edit";

    /**
     * Creates a new form to edit the FileStorageItem object specified by the item
     * selection model passed in.
     *
     * @param itemModel The ItemSelectionModel to use to obtain the FileStorageItem to
     * work on
     **/
    public FileStorageItemPropertyForm( ItemSelectionModel itemModel ) {
        this(itemModel,null);
    }
    /**
     * Creates a new form to edit the FileStorageItem object specified by the item
     * selection model passed in.
     *
     * @param itemModel The ItemSelectionModel to use to obtain the FileStorageItem to
     * work on
     * @param step The FileStorageItemPropertiesStep which controls this form.
     **/
    public FileStorageItemPropertyForm( ItemSelectionModel itemModel, FileStorageItemPropertiesStep step ) {
        super( ID, itemModel );
        m_step = step;
        addSubmissionListener(this);
    }

    /**
     * Adds widgets to the form.
     */
    protected void addWidgets() {
        super.addWidgets();

        add( new Label( FileStorageItem.DESCRIPTION_LABEL ) );
        ParameterModel descriptionParam
            = new StringParameter( FileStorageItem.DESCRIPTION );
        descriptionParam
            .addParameterListener( new NotNullValidationListener() );
        CMSDHTMLEditor description = new CMSDHTMLEditor( descriptionParam );
        description.setCols( 40 );
        description.setRows( 8 );
        add( description );

    }

    /** Form initialisation hook. Fills widgets with data. */
    public void init( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        FileStorageItem glossary_item
            = (FileStorageItem) super.initBasicWidgets( fse );

        data.put( FileStorageItem.DESCRIPTION, glossary_item.getDescription() );
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (m_step != null &&
            getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }
 
    /** Form processing hook. Saves FileStorageItem object. */
    public void process( FormSectionEvent fse ) {
        FormData data = fse.getFormData();
        
        FileStorageItem glossary_item
            = (FileStorageItem) super.processBasicWidgets( fse );

        // save only if save button was pressed
        if( glossary_item != null
            && getSaveCancelSection().getSaveButton()
            .isSelected( fse.getPageState() ) ) {
            glossary_item.setDescription( (String)
                                          data.get( FileStorageItem.DESCRIPTION ) );
            glossary_item.save();
        }
        if (m_step != null) {
            m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}
