/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.cms.contenttypes.FileStorageItem;
import com.arsdigita.cms.contenttypes.ui.FileStorageItemPropertyForm;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.text.DateFormat;
import org.apache.log4j.Logger;

/**
 * Authoring step to edit the simple attributes of the FileStorageItem content 
 * type (and its subclasses). 
 */
public class FileStorageItemPropertiesStep
    extends SimpleEditStep {

    private static final Logger s_log =
        Logger.getLogger(FileStorageItemPropertiesStep.class);

    /** The name of the editing sheet added to this step */
    public static final String EDIT_SHEET_NAME = "edit";

    public FileStorageItemPropertiesStep( ItemSelectionModel itemModel,
                                          AuthoringKitWizard parent ) {
        super( itemModel, parent );

        setDefaultEditKey(EDIT_SHEET_NAME);
        BasicPageForm editSheet;

        editSheet = new FileStorageItemPropertyForm( itemModel, this);
        add( EDIT_SHEET_NAME, "Edit",
             new WorkflowLockedComponentAccess(editSheet, itemModel),
             editSheet.getSaveCancelSection().getCancelButton() );

        setDisplayComponent( getFileStorageDomainObjectPropertySheet( itemModel ) );
    }

    /**
     * Returns a component that displays the properties of the 
     * FileStorageItem specified by the ItemSelectionModel passed in.
     * @param itemModel The ItemSelectionModel to use
     * @pre itemModel != null
     * @return A component to display the state of the basic properties
     *  of the release
     */
    public static Component getFileStorageDomainObjectPropertySheet( ItemSelectionModel
                                                             itemModel ) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet( itemModel );

        sheet.add(GlobalizationUtil.globalize("cms.ui.authoring.name"), FileStorageItem.NAME );
        sheet.add( GlobalizationUtil.globalize("cms.ui.authoring.title"), FileStorageItem.TITLE );
        sheet.add( GlobalizationUtil.globalize("cms.contenttypes.summary"), FileStorageItem.DESCRIPTION );

        return sheet;
    }
}
