/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.FileAsset;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.util.Assert;

import org.apache.log4j.Logger;

import java.math.BigDecimal;

/**
 * This content type represents a FileStorageItem.
 *
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */
public class FileStorageItem extends ContentPage {

    private final static Logger s_log = Logger.getLogger(FileStorageItem.class);

    /** PDL property name for description */
    public static final String DESCRIPTION = "description";
    /** PDL property name for file */
    public static final String FILE = "file";

    /** Labels to avoid duplicated hard-coded strings anywhere in the content
     * type files */
    public static final String DESCRIPTION_LABEL = "Description: ";
    public static final String ITEM_LABEL = "FileStorageItem";
    public static final String DESCRIPTION_TYPE = "An FileStorageItem type.";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.FileStorageItem";

    public static final int DESCRIPTION_LENGTH = 500;

    public FileStorageItem() {
        this( BASE_DATA_OBJECT_TYPE );
    }

    public FileStorageItem( BigDecimal id )
        throws DataObjectNotFoundException {
        this( new OID( BASE_DATA_OBJECT_TYPE, id ) );
    }

    public FileStorageItem( OID id )
        throws DataObjectNotFoundException {
        super( id );
    }

    public FileStorageItem( DataObject obj ) {
        super( obj );
    }

    public FileStorageItem( String type ) {
        super( type );
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }


    /* accessors *****************************************************/
    public String getDescription() {
        return (String) get( DESCRIPTION );
    }

    public void setDescription( String description ) {
        set( DESCRIPTION, description );
    }

    // Search stuff to allow the content type to be searchable
    public static final int SUMMARY_LENGTH = 200;
    public String getSearchSummary() {
        return com.arsdigita.util.StringUtils.truncateString(getDescription(),
                                                             SUMMARY_LENGTH,
                                                             true);
    }

    public FileAsset getFile() {
        DataObject file = (DataObject) get(FILE);
        if (file != null) {
            return new FileAsset(file);
        } else {
            return null;
        }
    }

    public void setFile(FileAsset file) {
        setAssociation(FILE, file);
    }

}
