/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.FileStorageItem;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.io.File;
import java.io.IOException;

public class FileStorageItemFileEdit
extends SimpleEditStep {
    public FileStorageItemFileEdit(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent, "_file");
        this.setDefaultEditKey("editfile");
        FileEditForm form = new FileEditForm(itemModel);
        this.add("editfile", "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)form, itemModel), form.getSaveCancelSection().getCancelButton());
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.ui.file"), "file.name");
        this.setDisplayComponent((Component)sheet);
    }

    private class FileEditForm
    extends BasicPageForm
    implements FormProcessListener,
    FormSubmissionListener {
        private FileUploadSection m_fileUploadSection;

        public FileEditForm(ItemSelectionModel itemModel) {
            super("FileEdit", new ColumnPanel(2), itemModel);
            this.addWidgets();
            this.addSubmissionListener(this);
            this.addProcessListener(this);
        }

        protected void addWidgets() {
            this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.ui.file")));
            this.add((Component)new Label(new PrintListener(this){
                private final /* synthetic */ FileEditForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    Label l = (Label)e.getTarget();
                    FileStorageItem item = (FileStorageItem)this.this$1.getItemSelectionModel().getSelectedObject(s);
                    FileAsset file = item.getFile();
                    if (file != null) {
                        l.setLabel(file.getName());
                    } else {
                        l.setLabel(GlobalizationUtil.globalize((String)"cms.ui.authoring.none"));
                    }
                }
            }));
            this.m_fileUploadSection = new FileUploadSection(GlobalizationUtil.globalize((String)"cms.ui.authoring.file_upload.file_type"), "", "");
            this.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
            this.add((Component)this.m_fileUploadSection);
            super.addSaveCancelSection();
        }

        public void init(FormSectionEvent e) throws FormProcessException {
        }

        public void submitted(FormSectionEvent fse) {
            if (this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
                FileStorageItemFileEdit.this.cancelStreamlinedCreation(fse.getPageState());
            }
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState s = e.getPageState();
            FileStorageItem item = (FileStorageItem)this.getItemSelectionModel().getSelectedObject(s);
            if (item != null) {
                try {
                    FileAsset file = new FileAsset();
                    String fileName = this.m_fileUploadSection.getFileName(e);
                    File uploadFile = this.m_fileUploadSection.getFile(e);
                    MimeType type = MimeType.guessMimeTypeFromFile((String)fileName);
                    file.loadFromFile(fileName, uploadFile, type == null ? null : type.getMimeType());
                    file.save();
                    item.setFile(file);
                    item.save();
                }
                catch (IOException err) {
                    throw new RuntimeException(err.getMessage());
                }
            }
            FileStorageItemFileEdit.this.maybeForwardToNextStep(e.getPageState());
        }
    }
}

