/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.cms.contenttypes.FAQItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.cms.contenttypes.util.FAQGlobalizationUtil;

import java.math.BigDecimal;
import java.lang.Exception;

/*
 * A page that will create a new FAQItem.
 * 
 * @author Dirk Gomez
 * @see com.arsdigita.intranet.cms.FAQItem
 * @version $Revision: #4 $
 */
public class FAQItemCreate extends PageCreate {

    public static final String QUESTION = "question";
    public static final String ANSWER = "answer";

    private CreationSelector m_parent;

    public FAQItemCreate(ItemSelectionModel itemModel,
                         CreationSelector parent) {

        super(itemModel, parent);
        m_parent = parent;
    }

    protected void addWidgets() {
        
        super.addWidgets();
        
        TextArea question = new TextArea(QUESTION);
        question.addValidationListener(new NotNullValidationListener());
        question.setCols(40);
        question.setRows(5);

        add(new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.question")));
        add(question);

        TextArea answer = new TextArea(ANSWER);
        answer.addValidationListener(new NotNullValidationListener());
        answer.setCols(40);
        answer.setRows(5);

        add(new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.answer")));
        add(answer);
    }

    public void process(FormSectionEvent e) throws FormProcessException {

        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ItemSelectionModel m = getItemSelectionModel();

        // Try to get the content section from the state parameter
        Folder f = m_parent.getFolder(state);
        ContentSection sec = m_parent.getContentSection(state);
        FAQItem item = (FAQItem)createContentPage(state);
        item.setLanguage((String) data.get(LANGUAGE));        
        item.setName((String)data.get(NAME));
        item.setTitle((String)data.get(TITLE));
        item.setQuestion((String)data.get(QUESTION));
        item.setAnswer((String)data.get(ANSWER));
        item.save();

        final ContentBundle bundle = new ContentBundle(item);
        bundle.setParent(f);
        bundle.setContentSection(m_parent.getContentSection(state));
        bundle.save();
        
        // Apply default workflow
        getWorkflowSection().applyWorkflow(state, item);
        
        // Start edititng the component right away
        m_parent.editItem(state, item);
    }
}








