/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.contenttypes.FAQItem;

import com.arsdigita.bebop.Component;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.contenttypes.util.FAQGlobalizationUtil;


/**
 * Authoring step to edit the simple attributes of the FAQItem content 
 * type (and its subclasses). 
 */
public class FAQItemPropertiesStep
    extends SimpleEditStep {

    /** The name of the editing sheet added to this step */
    public static final String EDIT_SHEET_NAME = "edit";

    public FAQItemPropertiesStep( ItemSelectionModel itemModel,
                                  AuthoringKitWizard parent ) {
        super( itemModel, parent );

        setDefaultEditKey(EDIT_SHEET_NAME);
        BasicPageForm editSheet;

        editSheet = new FAQItemPropertyForm( itemModel, this);
        add( EDIT_SHEET_NAME, "Edit", 
             new WorkflowLockedComponentAccess(editSheet, itemModel),
             editSheet.getSaveCancelSection().getCancelButton() );

        setDisplayComponent( getFAQDomainObjectPropertySheet( itemModel ) );
    }

    /**
     * Returns a component that displays the properties of the 
     * FAQItem specified by the ItemSelectionModel passed in.
     * @param itemModel The ItemSelectionModel to use
     * @pre itemModel != null
     * @return A component to display the state of the basic properties
     *  of the release
     */
    public static Component getFAQDomainObjectPropertySheet( ItemSelectionModel
                                                     itemModel ) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet( itemModel );

        sheet.add( FAQGlobalizationUtil.globalize("cms.ui.authoring.name_url"), FAQItem.NAME );
        sheet.add( FAQGlobalizationUtil.globalize("cms.ui.authoring.page_title"), FAQItem.TITLE );
        sheet.add( FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.question"), FAQItem.QUESTION );
        sheet.add( FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.answer"), FAQItem.ANSWER );
        sheet.add( FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.sectionName"), FAQItem.SECTION_NAME );

        return sheet;
    }
}





