/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.util.Assert;

import java.math.BigDecimal;


/**
 * This content type represents a FAQItem.
 *
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */
public class FAQItem extends ContentPage {

    /** PDL property name for question */
    public static final String QUESTION = "question";
    /** PDL property name for answer */
    public static final String ANSWER = "answer";
    /** PDL property for name of section */
    public static final String SECTION_NAME = "sectionName";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.FAQItem";

    public FAQItem() {
        this( BASE_DATA_OBJECT_TYPE );
    }

    public FAQItem( BigDecimal id )
        throws DataObjectNotFoundException {
        this( new OID( BASE_DATA_OBJECT_TYPE, id ) );
    }

    public FAQItem( OID id )
        throws DataObjectNotFoundException {
        super( id );
    }

    public FAQItem( DataObject obj ) {
        super( obj );
    }

    public FAQItem( String type ) {
        super( type );
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }


    /* accessors *****************************************************/
    public String getQuestion() {
        return (String) get( QUESTION );
    }

    public void setQuestion( String question ) {
        set( QUESTION, question );
    }

    public String getSectionName() {
        return (String) get( SECTION_NAME);
    }

    public void setSectionName( String sn) {
        set( SECTION_NAME, sn );
    }

    public String getAnswer() {
      return (String) get( ANSWER );
  }

  public void setAnswer( String answer ) {
      set( ANSWER, answer );
  }

    // Search stuff to allow the content type to be searchable
    public String getSearchSummary() {
        return getQuestion();
    }

}
