/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.FAQItem;
import com.arsdigita.cms.contenttypes.util.FAQGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.kernel.ACSObject;

public class FAQItemCreate
extends PageCreate {
    public static final String QUESTION = "question";
    public static final String ANSWER = "answer";
    private CreationSelector m_parent;

    public FAQItemCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super(itemModel, parent);
        this.m_parent = parent;
    }

    protected void addWidgets() {
        super.addWidgets();
        TextArea question = new TextArea(QUESTION);
        question.addValidationListener((ParameterListener)new NotNullValidationListener());
        question.setCols(40);
        question.setRows(5);
        this.add((Component)new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.question")));
        this.add((Component)question);
        TextArea answer = new TextArea(ANSWER);
        answer.addValidationListener((ParameterListener)new NotNullValidationListener());
        answer.setCols(40);
        answer.setRows(5);
        this.add((Component)new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.answer")));
        this.add((Component)answer);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ItemSelectionModel m = this.getItemSelectionModel();
        Folder f = this.m_parent.getFolder(state);
        ContentSection sec = this.m_parent.getContentSection(state);
        FAQItem item = (FAQItem)this.createContentPage(state);
        item.setLanguage((String)data.get((Object)"language"));
        item.setName((String)data.get((Object)"name"));
        item.setTitle((String)data.get((Object)"title"));
        item.setQuestion((String)data.get((Object)QUESTION));
        item.setAnswer((String)data.get((Object)ANSWER));
        item.save();
        ContentBundle bundle = new ContentBundle((ContentItem)item);
        bundle.setParent((ACSObject)f);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.getWorkflowSection().applyWorkflow(state, (ContentItem)item);
        this.m_parent.editItem(state, (ContentItem)item);
    }
}

