/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Time;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TimeParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Event;
import com.arsdigita.cms.contenttypes.ui.EventPropertiesStep;
import com.arsdigita.cms.contenttypes.util.EventGlobalizationUtil;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import java.util.Date;
import org.apache.log4j.Logger;

public class EventPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$EventPropertyForm == null ? (class$com$arsdigita$cms$contenttypes$ui$EventPropertyForm = EventPropertyForm.class$("com.arsdigita.cms.contenttypes.ui.EventPropertyForm")) : class$com$arsdigita$cms$contenttypes$ui$EventPropertyForm));
    private EventPropertiesStep m_step;
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String EVENT_DATE = "eventDate";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String LOCATION = "location";
    public static final String LEAD = "lead";
    public static final String MAIN_CONTRIBUTOR = "main_contributor";
    public static final String EVENT_TYPE = "event_type";
    public static final String MAP_LINK = "map_link";
    public static final String COST = "cost";
    public static final String ID = "event_edit";
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$EventPropertyForm;

    public EventPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public EventPropertyForm(ItemSelectionModel itemModel, EventPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        DateParameter eventStartDateParam = new DateParameter(START_DATE);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.start_date")));
        eventStartDateParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        com.arsdigita.bebop.form.Date startDate = new com.arsdigita.bebop.form.Date((ParameterModel)eventStartDateParam);
        this.add((Component)startDate);
        DateParameter eventEndDateParam = new DateParameter(END_DATE);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.end_date")));
        com.arsdigita.bebop.form.Date endDate = new com.arsdigita.bebop.form.Date((ParameterModel)eventEndDateParam);
        this.add((Component)endDate);
        TimeParameter eventStartTimeParam = new TimeParameter(START_TIME);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.start_time")));
        eventStartTimeParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        Time startTime = new Time((ParameterModel)eventStartTimeParam);
        this.add((Component)startTime);
        TimeParameter eventEndTimeParam = new TimeParameter(END_TIME);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.end_time")));
        Time endTime = new Time((ParameterModel)eventEndTimeParam);
        this.add((Component)endTime);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.date_description")));
        StringParameter eventDateParam = new StringParameter(EVENT_DATE);
        CMSDHTMLEditor eventDate = new CMSDHTMLEditor((ParameterModel)eventDateParam);
        eventDate.setCols(40);
        eventDate.setRows(8);
        this.add((Component)eventDate);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.location")));
        StringParameter locationParam = new StringParameter(LOCATION);
        CMSDHTMLEditor location = new CMSDHTMLEditor((ParameterModel)locationParam);
        location.setCols(40);
        location.setRows(8);
        this.add((Component)location);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.lead")));
        StringParameter leadParam = new StringParameter(LEAD);
        TextArea lead = new TextArea((ParameterModel)leadParam);
        lead.setCols(40);
        lead.setRows(5);
        this.add((Component)lead);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.main_contributor")));
        StringParameter mainContributorParam = new StringParameter(MAIN_CONTRIBUTOR);
        CMSDHTMLEditor mainContributor = new CMSDHTMLEditor((ParameterModel)mainContributorParam);
        mainContributor.setCols(40);
        mainContributor.setRows(10);
        this.add((Component)mainContributor);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.event_type")));
        StringParameter eventTypeParam = new StringParameter(EVENT_TYPE);
        TextField eventType = new TextField((ParameterModel)eventTypeParam);
        eventType.setSize(30);
        eventType.setMaxLength(30);
        this.add((Component)eventType);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.link_to_map")));
        StringParameter mapLinkParam = new StringParameter(MAP_LINK);
        TextArea mapLink = new TextArea((ParameterModel)mapLinkParam);
        mapLink.setCols(40);
        mapLink.setRows(2);
        this.add((Component)mapLink);
        this.add((Component)new Label(EventGlobalizationUtil.globalize("cms.contenttypes.ui.cost")));
        TrimmedStringParameter costParam = new TrimmedStringParameter(COST);
        TextField cost = new TextField((ParameterModel)costParam);
        cost.setSize(30);
        cost.setMaxLength(30);
        this.add((Component)cost);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData d = e.getFormData();
        Date startDate = d.getDate((Object)START_DATE);
        Date endDate = d.getDate((Object)END_DATE);
        if (endDate != null && (startDate == null || startDate.compareTo(endDate) > 0)) {
            throw new FormProcessException((String)EventGlobalizationUtil.globalize("cms.contenttypes.ui.event.end_date_after_start_date").localize());
        }
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Event event = (Event)super.initBasicWidgets(fse);
        Date startDate = event.getStartDate();
        if (startDate == null) {
            startDate = new Date();
        }
        data.put((Object)EVENT_DATE, (Object)event.getEventDate());
        data.put((Object)START_DATE, (Object)startDate);
        data.put((Object)END_DATE, (Object)event.getEndDate());
        data.put((Object)START_TIME, (Object)event.getStartTime());
        data.put((Object)END_TIME, (Object)event.getEndTime());
        data.put((Object)LOCATION, (Object)event.getLocation());
        data.put((Object)LEAD, (Object)event.getLead());
        data.put((Object)MAIN_CONTRIBUTOR, (Object)event.getMainContributor());
        data.put((Object)EVENT_TYPE, (Object)event.getEventType());
        data.put((Object)MAP_LINK, (Object)event.getMapLink());
        data.put((Object)COST, (Object)event.getCost());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Event event = (Event)super.processBasicWidgets(fse);
        if (event != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            event.setMainContributor((String)data.get((Object)MAIN_CONTRIBUTOR));
            event.setEventType((String)data.get((Object)EVENT_TYPE));
            event.setMapLink((String)data.get((Object)MAP_LINK));
            event.setEventDate((String)data.get((Object)EVENT_DATE));
            event.setStartDate((Date)data.get((Object)START_DATE));
            event.setEndDate((Date)data.get((Object)END_DATE));
            event.setStartTime((Date)data.get((Object)START_TIME));
            event.setEndTime((Date)data.get((Object)END_TIME));
            event.setLocation((String)data.get((Object)LOCATION));
            event.setLead((String)data.get((Object)LEAD));
            event.setCost((String)data.get((Object)COST));
            event.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

