/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Event;
import com.arsdigita.cms.contenttypes.ui.EventPropertyForm;
import com.arsdigita.cms.contenttypes.util.EventGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class EventPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public EventPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        EventPropertyForm editSheet = new EventPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(EventPropertiesStep.getEventPropertySheet(itemModel));
    }

    public static Component getEventPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.name"), "name");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.title"), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.launch_date"), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return "<i>unknown</i>";
                }
            });
        }
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.start_time"), "startDate", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                Event e = (Event)item;
                if (e.getStartDate() != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(DateFormat.getDateInstance(1).format(e.getStartDate()));
                    if (e.getStartTime() != null) {
                        buf.append(". " + e.getDisplayStartTime());
                    }
                    return buf.toString();
                }
                return "<i>unknown</i>";
            }
        });
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.end_time"), "endDate", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                Event e = (Event)item;
                if (e.getEndDate() != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(DateFormat.getDateInstance(1).format(e.getEndDate()));
                    if (e.getEndTime() != null) {
                        buf.append(". " + e.getDisplayEndTime());
                    }
                    return buf.toString();
                }
                return "<i>unknown</i>";
            }
        });
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.date_description"), "eventDate");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.location"), "location");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.lead"), "lead");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.main_contributor"), "mainContributor");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.event_type"), "eventType");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.link_to_map"), "mapLink");
        sheet.add(EventGlobalizationUtil.globalize("cms.contenttypes.ui.cost"), "cost");
        return sheet;
    }
}

