/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;


import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Article;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;


/**
 * Form to edit the basic properties of an article. This form can be
 * extended to create forms for Article subclasses.
 */
public class ArticlePropertyForm
    extends BasicPageForm
    implements FormProcessListener, FormInitListener, FormSubmissionListener {
    private final static org.apache.log4j.Logger s_log =
        org.apache.log4j.Logger.getLogger(ArticlePropertyForm.class);

    private ArticlePropertiesStep m_step;

    public static final String LEAD = "lead";

    /**
     * Creates a new form to edit the Article object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    Article to work on
     */
    public ArticlePropertyForm( ItemSelectionModel itemModel ) {
        this( itemModel, null );
    }

    /**
     * Creates a new form to edit the Article object specified
     * by the item selection model passed in.
     * @param itemModel The ItemSelectionModel to use to obtain the
     *    Article to work on
     * @param step The ArticlePropertiesStep which controls this form.
     */
    public ArticlePropertyForm( ItemSelectionModel itemModel, ArticlePropertiesStep step ) {
        super( ID, itemModel );
        m_step = step;
        addSubmissionListener(this);
    }

    /**
     * Adds widgets to the form.
     */
    protected void addWidgets() {
        super.addWidgets();

        add( new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.lead") ) );
        ParameterModel leadParam
            = new StringParameter( LEAD );
        //leadParam
        //    .addParameterListener( new NotNullValidationListener() );
        TextArea lead = new TextArea( leadParam );
        lead.setCols( 40 );
        lead.setRows( 5 );
        add( lead );
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData d = e.getFormData();
    }




    /** Form initialisation hook. Fills widgets with data. */
    public void init( FormSectionEvent fse ) {
        // Do some initialization hook stuff
        FormData data = fse.getFormData();
        Article article
            = (Article) super.initBasicWidgets( fse );

        data.put( LEAD,      article.getLead() );
    }

    /** Cancels streamlined editing. */
    public void submitted( FormSectionEvent fse ) {
        if (m_step != null &&
            getSaveCancelSection().getCancelButton()
            .isSelected( fse.getPageState())) {
            m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    /** Form processing hook. Saves Event object. */
    public void process( FormSectionEvent fse ) {
        FormData data = fse.getFormData();

        Article article
            = (Article) super.processBasicWidgets( fse );

        // save only if save button was pressed
        if( article != null
            && getSaveCancelSection().getSaveButton()
            .isSelected( fse.getPageState() ) ) {

            article.setLead( (String) data.get( LEAD ) );
            article.save();
        }
        if (m_step != null) {
            m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}
