/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;

import com.arsdigita.db.*;
import com.arsdigita.persistence.pdl.*;
import com.arsdigita.runtime.*;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.persistence.DataObject;

import org.apache.log4j.Logger;

/**
 * The CMS initializer.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/content-types/article/dev/src/com/arsdigita/cms/contenttypes/ArticleInitializer.java#4 $
 */
public class ArticleInitializer extends ContentTypeInitializer {
    public final static String versionId =
        "$Id: //cms/content-types/article/dev/src/com/arsdigita/cms/contenttypes/ArticleInitializer.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ArticleInitializer.class);

    public ArticleInitializer() {
        super("ccm-cms-types-article.pdl.mf", Article.BASE_DATA_OBJECT_TYPE);
    }


    public String[] getStylesheets() {
        return new String[] { "/static/content-types/com/arsdigita/cms/contenttypes/Article.xsl" };
    }
}
