/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.DateTime;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.DateTimeParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Agenda;
import com.arsdigita.cms.contenttypes.ui.AgendaPropertiesStep;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.util.Date;

public class AgendaPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private AgendaPropertiesStep m_step;
    public static final String AGENDA_DATE = "agendaDate";
    public static final String LOCATION = "location";
    public static final String ATTENDEES = "attendees";
    public static final String SUBJECT_ITEMS = "subjectItems";
    public static final String CONTACT_INFO = "contactInfo";
    public static final String SUMMARY = "summary";
    public static final String CREATION_DATE = "creationDate";
    public static final String ID = "Agenda_edit";

    public AgendaPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public AgendaPropertyForm(ItemSelectionModel itemModel, AgendaPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.agenda_date")));
        DateTimeParameter agendaDateParam = new DateTimeParameter(AGENDA_DATE);
        agendaDateParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        DateTime agendaDate = new DateTime((ParameterModel)agendaDateParam);
        this.add((Component)agendaDate);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.location")));
        StringParameter locationParam = new StringParameter(LOCATION);
        TextArea location = new TextArea((ParameterModel)locationParam);
        location.setCols(40);
        location.setRows(3);
        this.add((Component)location);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.attendees")));
        StringParameter attendeesParam = new StringParameter(ATTENDEES);
        TextArea attendees = new TextArea((ParameterModel)attendeesParam);
        attendees.setCols(40);
        attendees.setRows(3);
        this.add((Component)attendees);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.subject_items")));
        StringParameter subjectItemsParam = new StringParameter(SUBJECT_ITEMS);
        TextArea subjectItems = new TextArea((ParameterModel)subjectItemsParam);
        subjectItems.setCols(40);
        subjectItems.setRows(3);
        this.add((Component)subjectItems);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.contact_info")));
        StringParameter contactInfoParam = new StringParameter(CONTACT_INFO);
        TextArea contactInfo = new TextArea((ParameterModel)contactInfoParam);
        contactInfo.setCols(40);
        contactInfo.setRows(3);
        this.add((Component)contactInfo);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.summary")));
        StringParameter summaryParam = new StringParameter(SUMMARY);
        TextArea summary = new TextArea((ParameterModel)summaryParam);
        summary.setCols(40);
        summary.setRows(5);
        this.add((Component)summary);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.creation_date")));
        DateParameter creationDateParam = new DateParameter(CREATION_DATE);
        creationDateParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        com.arsdigita.bebop.form.Date creationDate = new com.arsdigita.bebop.form.Date((ParameterModel)creationDateParam);
        this.add((Component)creationDate);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Agenda agenda = (Agenda)super.initBasicWidgets(fse);
        Date creationDate = agenda.getCreationDate();
        if (creationDate == null) {
            creationDate = new Date();
        }
        data.put((Object)CREATION_DATE, (Object)creationDate);
        data.put((Object)AGENDA_DATE, (Object)agenda.getAgendaDate());
        data.put((Object)SUBJECT_ITEMS, (Object)agenda.getSubjectItems());
        data.put((Object)CONTACT_INFO, (Object)agenda.getContactInfo());
        data.put((Object)LOCATION, (Object)agenda.getLocation());
        data.put((Object)ATTENDEES, (Object)agenda.getAttendees());
        data.put((Object)SUMMARY, (Object)agenda.getSummary());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Agenda agenda = (Agenda)super.processBasicWidgets(fse);
        if (agenda != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            agenda.setAgendaDate((Date)data.get((Object)AGENDA_DATE));
            agenda.setSubjectItems((String)data.get((Object)SUBJECT_ITEMS));
            agenda.setContactInfo((String)data.get((Object)CONTACT_INFO));
            agenda.setLocation((String)data.get((Object)LOCATION));
            agenda.setAttendees((String)data.get((Object)ATTENDEES));
            agenda.setSummary((String)data.get((Object)SUMMARY));
            agenda.setCreationDate((Date)data.get((Object)CREATION_DATE));
            agenda.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

