/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;


import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.TextPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;

/**
 * This content type represents an agenda.
 *
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
public class Agenda extends TextPage {

    /** PDL property name for agenda date */
    public static final String AGENDA_DATE = "agendaDate";
    /** PDL property name for location */
    public static final String LOCATION = "location";
    /** PDL property name for attendees */
    public static final String ATTENDEES = "attendees";
    /** PDL property name for subject items */
    public static final String SUBJECT_ITEMS = "subjectItems";
    /** PDL property name for contact info */
    public static final String CONTACT_INFO = "contactInfo";
    /** PDL property name for summary */
    public static final String SUMMARY = "summary";
    /** PDL property name for creation date */
    public static final String CREATION_DATE = "creationDate";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.Agenda";
    /** Data object type for this domain object (for CMS compatibility) */

    private static final Logger s_log = Logger.getLogger(Logger.class);

    public Agenda() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Agenda(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Agenda(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Agenda(DataObject obj) {
        super(obj);
    }

    public Agenda(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }

    /* accessors *****************************************************/
    public Date getAgendaDate() {
        return (Date) get(AGENDA_DATE);
    }

    public String getDisplayAgendaDate () {
        Date d = getAgendaDate();
        return (d != null) ? DateFormat.getDateInstance(DateFormat.LONG)
            .format(d) : null;
    }
    public void setAgendaDate(Date agendaDate) {
        set(AGENDA_DATE, agendaDate);
    }

    public String getLocation() {
        return (String) get(LOCATION);
    }

    public void setLocation(String location) {
        set(LOCATION, location);
    }

    public String getAttendees() {
        return  (String) get(ATTENDEES);
    }

    public void setAttendees(String attendees) {
        set(ATTENDEES, attendees);
    }

    public String getSubjectItems() {
        return  (String) get(SUBJECT_ITEMS);
    }

    public void setSubjectItems(String subjectItems) {
        set(SUBJECT_ITEMS, subjectItems);
    }

    public String getContactInfo() {
        return (String) get(CONTACT_INFO);
    }

    public void setContactInfo(String contactInfo) {
        set(CONTACT_INFO, contactInfo);
    }

    public String getSummary() {
        return (String) get(SUMMARY);
    }

    public void setSummary(String summary) {
        set(SUMMARY, summary);
    }

    public Date getCreationDate() {
        return (Date) get(CREATION_DATE);
    }

    public void setCreationDate(Date creationDate) {
        set(CREATION_DATE, creationDate);
    }

    // Search stuff to allow the content type to be searchable
    public static final int SUMMARY_LENGTH = 200;

    public String getSearchSummary() {
        TextAsset ta = getTextAsset();

        if (ta != null) {
                return com.arsdigita.util.StringUtils.truncateString(ta.getText(),
                                                                     SUMMARY_LENGTH,
                                                                     true);
        } else {
            return "";
        }
    }

}
