/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.util.GlobalizationUtil;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

/**
 * This content type represents a generic address which is not country specific.
 *
 * @author <a href="mailto:dominik@redhat.com">Dominik Kacprzak</a>
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
public class Address extends ContentPage {

    /** PDL property name for address */
    public static final String ADDRESS = "address";
    /** PDL property name for country iso code */
    public static final String ISO_COUNTRY_CODE = "isoCountryCode";
    /** PDL property name for postal code */
    public static final String POSTAL_CODE = "postalCode";
    /** PDL property name for phone number */
    public static final String PHONE = "phone";
    /** PDL property name for mobile phone number */
    public static final String MOBILE = "mobile";
    /** PDL property name for fax number */
    public static final String FAX = "fax";
    /** PDL property name for email address */
    public static final String EMAIL = "email";
    /** PDL property name for notes */
    public static final String NOTES = "notes";
    /** PDL property name for URI*/
    public static final String URI = "uri";

    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.Address";

    public Address() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Address(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Address(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Address(DataObject obj) {
        super(obj);
    }

    public Address(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        
        Assert.exists(getContentType(), ContentType.class);
    }

    /* accessors *****************************************************/
    public String getAddress( ) {
        return ( String ) get( ADDRESS );
    }

    public void setAddress( String address ) {
        set( ADDRESS, address );
    }

    public String getCountryIsoCode( ) {
        DataObject obj = ( DataObject ) get( ISO_COUNTRY_CODE );
        if ( obj != null ) {
            IsoCountry country = new IsoCountry( obj );
            return country.getIsoCode( );
        }
        return null;
    }

    public void setCountryIsoCode( String isoCode ) {
        IsoCountry assn = null;
        try {
            OID oid = new OID( IsoCountry.BASE_DATA_OBJECT_TYPE );
            oid.set( IsoCountry.ISO_CODE, isoCode );

            assn = new IsoCountry( oid );
        } catch (DataObjectNotFoundException e) {
            assn = new IsoCountry( );
            assn.setIsoCode( isoCode );
            assn.save();
        }
        setAssociation( ISO_COUNTRY_CODE,  assn );
    }

    public String getPostalCode( ) {
        return ( String ) get( POSTAL_CODE );
    }

    public void setPostalCode( String postalCode ) {
        set( POSTAL_CODE, postalCode );
    }

    public String getPhone( ) {
        return ( String ) get( PHONE );
    }

    public void setPhone( String phone ) {
        set( PHONE, phone );
    }

    public String getMobile( ) {
        return ( String ) get( MOBILE );
    }

    public void setMobile( String mobile ) {
        set( MOBILE, mobile );
    }

    public String getFax( ) {
        return ( String ) get( FAX );
    }

    public void setFax( String fax ) {
        set( FAX, fax );
    }

    public String getEmail( ) {
        return ( String ) get( EMAIL );
    }

    public void setEmail( String email ) {
        set( EMAIL, email );
    }

    public String getNotes( ) {
        return ( String ) get( NOTES );
    }

    public void setNotes( String notes ) {
        set( NOTES, notes );
    }

    public void setURI( String uri) {
        set(URI, uri);
    }

    public String getURI() {
        return (String)get(URI);
    }

}
