/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Address;
import com.arsdigita.cms.contenttypes.ui.AddressPropertyForm;
import com.arsdigita.cms.contenttypes.util.AddressGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class AddressPropertiesStep
extends SimpleEditStep {
    public static final String EDIT_SHEET_NAME = "edit";

    public AddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        AddressPropertyForm editSheet = new AddressPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(AddressPropertiesStep.getAddressPropertySheet(itemModel));
    }

    public static Component getAddressPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.name").localize(), "name");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.title").localize(), "title");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.ui.authoring.page_launch_date").localize(), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                ContentPage page = (ContentPage)item;
                if (page.getLaunchDate() != null) {
                    return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                }
                return (String)AddressGlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.address").localize(), "address");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.iso_country_code").localize(), "isoCountryCode", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                Address address = (Address)item;
                if (address.getCountryIsoCode() != null) {
                    return address.getCountryIsoCode();
                }
                return (String)AddressGlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.postal_code").localize(), "postalCode");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.phone").localize(), "phone");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.mobile").localize(), "mobile");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.fax").localize(), "fax");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.email").localize(), "email");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.uri").localize(), "uri");
        sheet.add((String)AddressGlobalizationUtil.globalize("cms.contenttypes.ui.address.notes").localize(), "notes");
        return sheet;
    }
}

