/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;

import java.util.Iterator;
import java.util.LinkedList;

/**
 * This class represents country information, iso code and name.  The country
 * information is being used by {@link com.arsdigita.cms.contenttypes.Address}.
 *
 * @author <a href="mailto:dominik@redhat.com">Dominik Kacprzak</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/
public class IsoCountry extends DomainObject {        
    
    /** Data object type for this domain object */
    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.cms.contenttypes.IsoCountry";
    
    /** PDL property name for country iso code */
    public static final String ISO_CODE = "isoCode";
    /** PDL property name for country name */
    public static final String COUNTRY_NAME = "countryName";
    
    public IsoCountry( ) {
        super( BASE_DATA_OBJECT_TYPE );
    }
    
    public IsoCountry( OID oid ) throws DataObjectNotFoundException {
        super( oid );
    }
    
    public IsoCountry( DataObject obj ) {
        super(obj);
    }
    
    public String getIsoCode( ) {
        return ( String ) get( ISO_CODE );
    }
    
    public void setIsoCode( String isoCode ) {
        set( ISO_CODE, isoCode );
    }
    
    /** 
     *
     */
    public String getCountryName( ) {
        return ( String ) get( COUNTRY_NAME );
    }
    
    /**
     * Sets country name
     *
     * @param countryName
     */
    public void setCountryName( String countryName ) {
        set( COUNTRY_NAME, countryName );
    }

    public static DomainCollection retrieveAll() {
        DataCollection isoCodes = SessionManager.getSession()
            .retrieve( IsoCountry.BASE_DATA_OBJECT_TYPE );
        isoCodes.addOrder(COUNTRY_NAME);
        return new DomainCollection(isoCodes) {};
    }
    
    /**
     * Returns iterator of all available iso country codes as strings.
     *
     * @return iterator or <code>null</code> if there is no country codes 
     * available
     */
    public static Iterator getIsoCodes( ) {
        LinkedList list = new LinkedList();
        // get all iso codes
        DataCollection isoCodes = SessionManager.getSession()
            .retrieve( IsoCountry.BASE_DATA_OBJECT_TYPE );
        while ( isoCodes.next() ) {
            IsoCountry country = new IsoCountry( isoCodes.getDataObject( ) );
            list.addLast( country.getIsoCode() );
        }
        if ( list.size() != 0 ) {
            return list.iterator();
        }
        return null;
    }    
}
