/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.util;

import com.arsdigita.globalization.GlobalizedMessage;

/**
 * <p>
 * .
 * Contains methods to simplify globalizing keys
 * </p>
 *
 * @author <a href="mailto:randyg@arsdigita.com">randyg@arsdigita.com</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 */

public class AddressGlobalizationUtil {
    
    final public static String BUNDLE_NAME = 
        "com.arsdigita.cms.contenttypes.util.AddressResourceBundle";

    /**
     *  This returns a globalized message using the type specific bundle,
     *  BUNDLE_NAME
     */
    public static GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, BUNDLE_NAME);
    }

    /**
     *  This returns a globalized message using the type specific bundle,
     *  BUNDLE_NAME
     */
    public static GlobalizedMessage globalize(String key, Object[] args) {
        return new GlobalizedMessage(key, BUNDLE_NAME, args);
    }
}
