--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/content-types/address/dev/sql/ccm-cms-types-address/postgres/upgrade/address-upgrade-2.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table temp as select * from ct_addresses;
drop table ct_addresses;

create table ct_addresses (
    address_id INTEGER not null
        constraint ct_addresse_address_id_p_y1u3b
          primary key,
        -- referential constraint for address_id deferred due to circular dependencies
    address VARCHAR(1000),
    email VARCHAR(75),
    fax VARCHAR(20),
    iso_country_code CHAR(2),
        -- referential constraint for iso_country_code deferred due to circular dependencies
    mobile VARCHAR(20),
    notes TEXT,
    phone VARCHAR(20),
    postal_code VARCHAR(20),
    uri VARCHAR(250)
);
alter table ct_addresses add 
    constraint ct_addre_iso_coun_code_f_o8h8a foreign key (iso_country_code)
      references iso_countries(iso_code);
alter table ct_addresses add 
    constraint ct_addresse_address_id_f__qv8u foreign key (address_id)
      references cms_pages(item_id) on delete cascade;

insert into ct_addresses (address_id, address, email, fax, iso_country_code, mobile, notes, phone, postal_code, uri)
 select address_id, address, email, fax, iso_country_code, mobile, encode(notes, 'escape'), phone, postal_code, uri
  from temp;
drop table temp;
