/**
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 */

/**
 * Class to create an article with only text
 * 
 * @author bche@redhat.com
 */

package com.arsdigita.populate.cms;

import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.Article;

public class CreateTextArticle extends CreateArticle {
    
    public CreateTextArticle() {
        this(Article.class, "TextArticle");
    }

    public CreateTextArticle(Class itemClass, String name) {
        super(itemClass, name);
    }

    
    public void makeContent() {
        Article article = (Article)createItem();
        
        //create the lead
        article.setLead("All work and no play...");
        
        String sArticleID = article.getID().toString();

        //create the article body
        TextAsset txt =
            createTextAsset(article.getName() + "_text_" + sArticleID, article);

        article.setTextAsset(txt);

        article.save();
    }
}
