/**
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * @author bche@redhat.com
 */

package com.arsdigita.populate.cms;

import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.ArticleSection;
import com.arsdigita.cms.contenttypes.MultiPartArticle;
import org.apache.log4j.Logger;

public class CreateMultiPartArticle
    extends CreateContentPage {

    private static final Logger s_log =
        Logger.getLogger(CreateMultiPartArticle.class.getName());

    public CreateMultiPartArticle() {
        this(MultiPartArticle.class, "MultiPartArticle");
    }

    public CreateMultiPartArticle(Class itemClass, String name) {
        super(itemClass, name);
    }

    /**
     * @see CreateContentItem#makeContent()
     */
    public void makeContent() {
        MultiPartArticle article = (MultiPartArticle)createItem();
        article.setSummary(
            "Here's the multi-part story of a man named Jack.");
        
        //give the article 10 sections: 5 text sections and 5 image sections
        int iSections = 10;
        for (int i = 0; i < iSections; i++) {
            if (i % 2 == 0) {
                makeTextSection(article, i);
            } else {
                makeImageSection(article, i);
            }
        }
        
        article.save();
    }

    /**
     * Creates an image article section andd adds it to the article
     */
    protected void makeImageSection(MultiPartArticle article,
                                    int iIndex) {
        ImageAsset img =
            createImageAsset(
                "image section _" + article.getName() + "_" + iIndex,
                null);

        ArticleSection section = new ArticleSection();
        section.setName("image section _" + article.getName() + "_" + iIndex);
        section.setImage(img);        

        article.addSection(section);
    }

    /**
     * Creates a text article section and adds it to the article
     */
    protected void makeTextSection(MultiPartArticle article,
                                   int iIndex) {
        TextAsset txt =
            createTextAsset(
                article.getName()
                + "_text_"
                + article.getID()
                + "."
                + iIndex,
                article);

        //create an article section
        ArticleSection section = new ArticleSection();
        section.setName("text section _" + article.getName() + "_" + iIndex);
        section.setText(txt);        

        //add the section to the article
        article.addSection(section);
    }
}
