/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;


/**
 * Interface for populating a content type.  To populate a database with a CMS
 * content type, add a class that implements this interface.  The class should
 * use the setup(), makeContent(), and publish() methods to create and publish
 * one content item of the desired content type.  Then, add the class you wrote
 * to the initializer for this package.
 *
 * @author <a href="mailto:bche@redhat.com">Bryan Che</a>
 **/

public interface CreateContentItem {
    /**
     * Method setup.  Call first to do setup work
     * @param sIdentifier the title of the content item.  This should be unique
     * across content items
     * @param parent the parent of the created content tems.  Should usually be
     * a Folder.
     * @param section the content section in which to place the content item
     */
    void setup(String sIdentifier, ContentItem parent, ContentSection section);

    /**
     * Method makeContent.  Creates the content for the content item
     */
    void makeContent();

    /**
     * Method publish.  Publishes the content item
     */
    void publish();

    /**
     * Method getContentType.
     *
     * @return The fully qualified name of the content type we are creating.
     * For example, <i>com.arsdigita.cms.contenttype.article</i>
     */
    String getContentType();

    /**
     * Method getContentTypeName.
     * @return A pretty name for the content type we are creating.  For example,
     * <i>article</i>.  This name should be unique among content types.
     */
    String getContentTypeName();

    /**
     * Method getContentItem.  Returns the created content item, or null if it
     * has not been created yet
     */
    ContentItem getContentItem();
}
