/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.populate.cms;

import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.Article;
import org.apache.log4j.Logger;

public class CreateArticle extends CreateContentPage {
    
    private static final Logger s_log =
        Logger.getLogger(CreateArticle.class.getName());

    public CreateArticle() {
        this(Article.class, "Article");
    }
    
    public CreateArticle(Class itemClass, String name) {
        super(itemClass, name);
    }
    
    public void makeContent() {
        Article article = (Article)createItem();
        
        //create the lead
        article.setLead("All work and no play...");
        
        String sArticleID = article.getID().toString();

        //create the article body
        TextAsset txt =
            createTextAsset(article.getName() + "_text_" + sArticleID, article);

        article.setTextAsset(txt);

        //add an image

        ReusableImageAsset img =
            createReusableImageAsset(
                article.getName() + "_img_" + sArticleID,
                null);

        article.addImage(img, "This is an image");

        article.save();
    }
}
