/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.populate.cms.CreateContentItem;
import com.arsdigita.populate.cms.PopulateConfig;
import com.arsdigita.util.Assert;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.Workflow;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractCreateContentItem
implements CreateContentItem {
    private ImageAsset m_image = null;
    private ReusableImageAsset m_reusableImage = null;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$populate$cms$CreateContentItem == null ? (class$com$arsdigita$populate$cms$CreateContentItem = AbstractCreateContentItem.class$("com.arsdigita.populate.cms.CreateContentItem")) : class$com$arsdigita$populate$cms$CreateContentItem).getName());
    private static final PopulateConfig s_config = new PopulateConfig();
    static /* synthetic */ Class class$com$arsdigita$populate$cms$CreateContentItem;

    public abstract void setup(String var1, ContentItem var2, ContentSection var3);

    public abstract void makeContent();

    public abstract void publish();

    public abstract String getContentType();

    public abstract String getContentTypeName();

    public abstract ContentItem getContentItem();

    protected String makeTextBody(int iIndex) {
        StringBuffer sb = new StringBuffer(5000);
        for (int i = 0; i < 20; ++i) {
            sb.append(iIndex + " All work and no play makes Jack a dull boy.  ");
        }
        return sb.toString();
    }

    protected String makeTextBody() {
        return this.makeTextBody(0);
    }

    protected ImageAsset createImageAsset(String sName, ContentItem parent) {
        if (this.m_image != null) {
            return this.createImageAsset(this.m_image, sName, parent);
        }
        s_log.info((Object)"  adding image asset to the db");
        File imgFile = s_config.getImageFile();
        ImageAsset img = new ImageAsset();
        try {
            String sFileName = imgFile.getName();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("adding image file " + sFileName + " with path " + imgFile.getAbsolutePath()));
            }
            MimeType mime = MimeType.guessMimeTypeFromFile((String)sFileName);
            String sMime = "";
            if (mime != null) {
                sMime = mime.getMimeType();
                s_log.debug((Object)("setting mime type to " + sMime));
            }
            img.loadFromFile(sFileName, imgFile, sMime);
        }
        catch (IOException ioe) {
            s_log.error((Object)("IOException loading image " + ioe.getMessage()));
        }
        img.setName(sName);
        img.setParent((ACSObject)parent);
        img.save();
        this.m_image = img;
        return img;
    }

    private ImageAsset createImageAsset(ImageAsset img, String sName, ContentItem parent) {
        ImageAsset newImg = (ImageAsset)((ImageAsset)DomainObjectFactory.newInstance((OID)img.getOID())).copy();
        newImg.setName(sName);
        newImg.setParent((ACSObject)parent);
        newImg.save();
        return newImg;
    }

    protected ReusableImageAsset createReusableImageAsset(String sName, ContentItem parent) {
        if (this.m_reusableImage != null) {
            return this.createReusableImageAsset(this.m_reusableImage, sName, parent);
        }
        s_log.info((Object)"  adding reusableImage asset to the db");
        File imgFile = s_config.getImageFile();
        ReusableImageAsset img = new ReusableImageAsset();
        try {
            String sFileName = imgFile.getName();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("adding image file " + sFileName + " with path " + imgFile.getAbsolutePath()));
            }
            MimeType mime = MimeType.guessMimeTypeFromFile((String)sFileName);
            String sMime = "";
            if (mime != null) {
                sMime = mime.getMimeType();
                s_log.debug((Object)("setting mime type to " + sMime));
            }
            img.loadFromFile(sFileName, imgFile, sMime);
        }
        catch (IOException ioe) {
            s_log.error((Object)("IOException loading image " + ioe.getMessage()));
        }
        img.setName(sName);
        img.setParent((ACSObject)parent);
        img.save();
        this.m_reusableImage = img;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("added resuableImage: " + img.getName() + " " + img.getMimeType() + " " + img.getSize()));
        }
        return img;
    }

    private ReusableImageAsset createReusableImageAsset(ReusableImageAsset img, String sName, ContentItem parent) {
        ReusableImageAsset newImg = (ReusableImageAsset)((ReusableImageAsset)DomainObjectFactory.newInstance((OID)img.getOID())).copy();
        newImg.setName(sName);
        newImg.setParent((ACSObject)parent);
        newImg.save();
        return newImg;
    }

    protected TextAsset createTextAsset(String sName, ContentItem parent, String sText) {
        TextAsset txt = new TextAsset();
        txt.setText(sText);
        txt.setName(sName);
        txt.setParent((ACSObject)parent);
        txt.save();
        return txt;
    }

    protected TextAsset createTextAsset(String sName, ContentItem parent) {
        return this.createTextAsset(sName, parent, this.makeTextBody());
    }

    protected TextAsset createTextAsset(String sName, ContentItem parent, int iIndex) {
        return this.createTextAsset(sName, parent, this.makeTextBody(iIndex));
    }

    protected User getAdminUser() {
        UserCollection uc = User.retrieveAll();
        uc.filter(KernelHelper.getSystemAdministratorEmailAddress());
        uc.next();
        User sysadmin = uc.getUser();
        Assert.assertNotNull((Object)sysadmin);
        uc.close();
        return sysadmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTasks(Workflow w) {
        block7: {
            User sysadmin = this.getAdminUser();
            w.start(sysadmin);
            TaskCollection tasks = w.getTaskCollection();
            block5: while (true) {
                while (tasks.next()) {
                    CMSTask task = (CMSTask)tasks.getTask();
                    task.enable();
                    try {
                        task.finish(sysadmin, "finished");
                        continue block5;
                    }
                    catch (TaskException e) {
                        s_log.error((Object)("TaskException: " + e.getMessage()));
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                tasks.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load();
    }
}

