/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;

/**
 * Class for populating users that are CMS content readers
 * @author bche
 */
public class PopulateUsers {
    private String m_sBaseStringSeed = null;
    private static final org.apache.log4j.Logger s_log =
            org.apache.log4j.Logger.getLogger(PopulateUsers.class.getName());
        
    private static String s_sPassword = "test";
    private static String s_sQuestion = "test";
    private static String s_sAnswer = "test";   

    public PopulateUsers(){                                 
    }

    public void setBaseStringSeed(String sSeed) {
        m_sBaseStringSeed = sSeed;
    }
    
    public String getBaseStringSeed() {
        return m_sBaseStringSeed;
    }    
    
    /**
     * Populates iUsers users and makes them content readers of the content section, section
     * @param iUsers the number of users to create
     * @param section the content section to which to add the users as readers
     * @throws IllegalArgumentException
     */
    public void populate(int iUsers, ContentSection section) throws IllegalArgumentException {
        if (iUsers < 0) {
                    throw new IllegalArgumentException("Number of Users must be >= 0");
        }
        
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        
        String sUserDate = Utilities.getBaseString(m_sBaseStringSeed);                      

        //create users
        for (int i=0; i < iUsers; i++) {
            txn.beginTxn();

            //create the user
            String sScreenName = "testuser" + sUserDate + i;
            String sEmail = sScreenName + "@redhat.rhat";
            User newbie = new User();
            newbie.getPersonName().setGivenName("Test");
            newbie.getPersonName().setFamilyName("User" + sUserDate + i);
            newbie.setPrimaryEmail(new EmailAddress(sEmail));
            newbie.setScreenName(sScreenName);
            newbie.setURI("http://rhea.redhat.com");

            // note: newbie has to have primaryEmail set first,
            // before you can call UserAuthentication
            newbie.save();
            UserAuthentication auth = null;
            auth = UserAuthentication.createForUser(newbie);
            auth.setPassword(s_sPassword);
            auth.setPasswordQuestion(s_sQuestion);
            auth.setPasswordAnswer(s_sPassword);
            auth.save();
            
            //make user a content viewer   
            Role viewers = section.getViewersGroup().getRole("Content Reader");
            viewers.getGroup().addMemberOrSubgroup(newbie);
            viewers.save();

            s_log.info(" Added User " + sEmail);

            txn.commitTxn(); 
        }
    }

}
