package com.arsdigita.populate.cms;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.FileParameter;
import com.arsdigita.util.parameter.Parameter;
import java.io.File;

public final class PopulateConfig extends AbstractConfig {

    public final static String versionId = "$Id: //cms/populate/dev/src/com/arsdigita/populate/cms/PopulateConfig.java#1 $ by $Author: ashah $, $DateTime: 2004/01/28 12:19:43 $";

    private static final String PARAM_PREFIX = "waf.populate.cms.";

    private final Parameter m_image = new FileParameter
        (PARAM_PREFIX + "image");

    public PopulateConfig() {
        register(m_image);
        loadInfo();
    }

    /**
     * Returns the image file loaded at run
     * @return the image file loaded at run
     */
    public File getImageFile() {
        return (File) get(m_image);
    }
}
