/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.populate.cms;

import com.arsdigita.cms.Folder;

import java.util.ArrayList;

/**
 * @author bche
 */
class FolderList {
            
    ArrayList m_folders;
    
    public FolderList() {
        m_folders = new ArrayList();
    }
    
    public FolderList(int initialCapacity) {
        m_folders = new ArrayList(initialCapacity);
    }
    
    public void add(int index, Folder folder) {
        m_folders.add(index, folder);
    }
    
    public void add(Folder folder) {
        m_folders.add(folder);
    }
    
    public void clear() {
        m_folders.clear();
    }
    
    public Folder remove(int index) {
        return  (Folder)m_folders.remove(index);
    }
    
    public Folder get(int index) {
        return (Folder)m_folders.get(index);
    }
    
    public int size() {
        return m_folders.size();
    }        
}
