/**
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 */

package com.arsdigita.populate.cms;

import com.arsdigita.cms.contenttypes.MultiPartArticle;

/**
 * Creates a multi-part article with only text
 * 
 * @author bche@redhat.com
 */

public class CreateTextMultiPartArticle
        extends CreateMultiPartArticle {

    public CreateTextMultiPartArticle() {
        this(MultiPartArticle.class, "TextMultiPartArticle");
    }

    public CreateTextMultiPartArticle(Class itemClass, String name) {
        super(itemClass, name);
    }
    
    /**
     * @see com.arsdigita.cms.populate.CreateContentItem#makeContent()
     */
    public void makeContent() {        
        MultiPartArticle article = (MultiPartArticle)createItem();
        article.setSummary(
            "Here's the multi-part story of a man named Jack.");
        
        //give the article 5 text sections
        int iSections = 5;
        for (int i = 0; i < iSections; i++) {
            makeTextSection(article, i);
        }
        
        article.save();
    }
}
