/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.Scheduler;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.cms.CreateContentItem;
import com.arsdigita.populate.cms.FolderList;
import com.arsdigita.populate.cms.PopulateContent;
import com.arsdigita.populate.cms.PopulateFolders;
import com.arsdigita.populate.cms.PopulateUsers;
import com.arsdigita.runtime.AbstractScript;
import com.arsdigita.runtime.InteractiveParameterLoader;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.runtime.Startup;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.ClassParameter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.ParameterLoader;
import com.arsdigita.util.parameter.ParameterReader;
import com.arsdigita.util.parameter.ParameterWriter;
import com.arsdigita.util.parameter.StringParameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class CMSLoader
extends AbstractScript {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$populate$cms$CMSLoader == null ? (class$com$arsdigita$populate$cms$CMSLoader = CMSLoader.class$("com.arsdigita.populate.cms.CMSLoader")) : class$com$arsdigita$populate$cms$CMSLoader));
    private static final String PARAM_PREFIX = "waf.populate.cms.";
    private static final String POP_USER_EMAIL = "population-user@redhat.rhat";
    private static final String POP_USER_FIRST_NAME = "population";
    private static final String POP_USER_LAST_NAME = "user";
    private final Parameter m_baseStringSeed = new StringParameter("waf.populate.cms.base_string_seed");
    private final Parameter m_contentSection;
    private final Parameter m_numTopLevelFolders;
    private final Parameter m_folderDepth;
    private final Parameter m_numContentItems;
    private final Parameter m_createContentTypes;
    private final Parameter m_numUsers;
    static /* synthetic */ Class class$com$arsdigita$populate$cms$CMSLoader;
    static /* synthetic */ Class class$com$arsdigita$populate$cms$CMSLoader$ClassArrayParameter;

    public CMSLoader() {
        this.register(this.m_baseStringSeed);
        this.m_contentSection = new StringParameter("waf.populate.cms.content_section");
        this.register(this.m_contentSection);
        this.m_numTopLevelFolders = new IntegerParameter("waf.populate.cms.num_top_level_folders");
        this.register(this.m_numTopLevelFolders);
        this.m_folderDepth = new IntegerParameter("waf.populate.cms.folder_depth");
        this.register(this.m_folderDepth);
        this.m_numContentItems = new IntegerParameter("waf.populate.cms.num_content_items");
        this.register(this.m_numContentItems);
        this.m_createContentTypes = new ClassArrayParameter("waf.populate.cms.create_content_types");
        this.register(this.m_createContentTypes);
        this.m_numUsers = new IntegerParameter("waf.populate.cms.num_users");
        this.register(this.m_numUsers);
    }

    private User getPopulationUser() {
        User u = null;
        String sContentSection = (String)this.get(this.m_contentSection);
        ContentSection section = this.getContentSection(sContentSection);
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        txn.beginTxn();
        UserCollection users = User.retrieveAll();
        users.addEqualsFilter("primaryEmail", (Object)POP_USER_EMAIL);
        if (users.next()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"retrieving population user from database");
            }
            u = users.getUser();
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"creating new population user");
            }
            u = new User(POP_USER_FIRST_NAME, POP_USER_LAST_NAME, POP_USER_EMAIL);
            u.save();
            UserAuthentication auth = null;
            auth = UserAuthentication.createForUser((User)u);
            auth.setPassword("redhat");
            auth.setPasswordQuestion("redhat");
            auth.setPasswordAnswer("redhat");
            auth.save();
        }
        users.close();
        txn.commitTxn();
        return u;
    }

    public void run(final ScriptContext context) {
        new KernelExcursion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void excurse() {
                User u = null;
                try {
                    u = CMSLoader.this.getPopulationUser();
                    s_log.info((Object)"GRANTING POPULATION USER SITE-WIDE ADMIN FOR POPULATION...");
                    PermissionService.grantPermission((PermissionDescriptor)new UniversalPermissionDescriptor(PrivilegeDescriptor.ADMIN, (Party)u));
                    this.setEffectiveParty((Party)u);
                    this.setParty((Party)u);
                    CMSLoader.this.doRun(context);
                    Object var3_2 = null;
                    if (u == null) return;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (u == null) throw throwable;
                    s_log.info((Object)"REVOKING SITE-WIDE ADMIN FROM  POPULATION USER AFTER  POPULATION...");
                    PermissionService.revokePartyPermissions((OID)u.getOID());
                    throw throwable;
                }
                s_log.info((Object)"REVOKING SITE-WIDE ADMIN FROM  POPULATION USER AFTER  POPULATION...");
                PermissionService.revokePartyPermissions((OID)u.getOID());
            }
        }.run();
    }

    private void doRun(ScriptContext context) {
        s_log.info((Object)"disabling PublishToFilesystem and Lifecycle during CMS population...");
        QueueManager.stopWatchingQueue();
        Scheduler.stopTimer();
        String sBaseStringSeed = (String)this.get(this.m_baseStringSeed);
        int iTopFolders = (Integer)this.get(this.m_numTopLevelFolders);
        int iFolderDepth = (Integer)this.get(this.m_folderDepth);
        int iContentItems = (Integer)this.get(this.m_numContentItems);
        String sContentSection = (String)this.get(this.m_contentSection);
        Class[] createContentTypes = (Class[])this.get(this.m_createContentTypes);
        Integer iUsers = (Integer)this.get(this.m_numUsers);
        s_log.info((Object)("Begin populating content items at " + new Date().toString() + "..."));
        long start = System.currentTimeMillis();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using BaseStringSeed " + sBaseStringSeed));
        }
        s_log.info((Object)("getting content section " + sContentSection));
        ContentSection section = this.getContentSection(sContentSection);
        if (section == null) {
            throw new NullPointerException("The content section " + sContentSection + " does not exist");
        }
        PopulateFolders popFolders = new PopulateFolders();
        popFolders.setBaseStringSeed(sBaseStringSeed);
        s_log.info((Object)("creating " + iTopFolders + " top-level folders with a depth of " + iFolderDepth));
        popFolders.populate(iTopFolders, iFolderDepth, section);
        s_log.info((Object)"finished creating folders");
        FolderList folders = popFolders.getFolders();
        folders.add(0, section.getRootFolder());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("using " + folders.size() + " folders for item population"));
        }
        s_log.info((Object)("creating " + iContentItems + " content items each for " + createContentTypes.length + " content types"));
        PopulateContent pop = new PopulateContent(iContentItems, section);
        pop.setBaseStringSeed(sBaseStringSeed);
        int iParentIndex = 0;
        for (int i = 0; i < createContentTypes.length; ++i) {
            Class createItemClass = createContentTypes[i];
            CreateContentItem createItem = null;
            try {
                createItem = (CreateContentItem)createItemClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("error getting createItem " + e.getMessage());
            }
            pop.populate(createItem, folders, iParentIndex);
            iParentIndex = pop.getLastFolderIndex() + 1;
        }
        s_log.info((Object)("Finished populating content items at " + new Date().toString() + "."));
        if (iContentItems > 0) {
            long elapsed = System.currentTimeMillis() - start;
            long per = elapsed / (long)(iContentItems * createContentTypes.length);
            s_log.info((Object)("Elapsed millis " + elapsed + " (" + per + " per item)"));
        }
        s_log.info((Object)("creating " + iUsers + " users"));
        PopulateUsers popUsers = new PopulateUsers();
        popUsers.setBaseStringSeed(sBaseStringSeed);
        s_log.info((Object)("Begin populating users at " + new Date().toString() + "."));
        popUsers.populate(iUsers, section);
        s_log.info((Object)("Finished populating users at " + new Date().toString() + "."));
        s_log.info((Object)"Restarting lifecycle and p2fs processes...");
        Scheduler.startTimer();
        QueueManager.startWatchingQueue((int)1, (int)5);
    }

    private ContentSection getContentSection(String sSection) throws DataObjectNotFoundException {
        this.validateURLParameter("content section", sSection);
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        SiteNode rootNode = SiteNode.getRootSiteNode();
        BigDecimal rootNodeId = rootNode.getID();
        ContentSection section = null;
        s_log.info((Object)("checking for content section " + sSection));
        SiteNode node = SiteNode.getSiteNode((String)("/" + sSection));
        section = rootNodeId.equals(node.getID()) ? null : ContentSection.getSectionFromNode((SiteNode)node);
        if (txn.inTxn()) {
            txn.commitTxn();
        }
        return section;
    }

    private void validateURLParameter(String name, String value) throws IllegalArgumentException {
        String pattern = "/[^A-Za-z_0-9\\-]+/";
        Perl5Util util = new Perl5Util();
        if (util.match("/[^A-Za-z_0-9\\-]+/", value)) {
            throw new IllegalArgumentException("The \"" + name + "\" parameter must contain only " + " alpha-numeric characters, underscores, and/or hyphens.");
        }
    }

    public static void main(String[] args) {
        new Startup().run();
        Session session = SessionManager.getSession();
        InteractiveParameterLoader loader = new InteractiveParameterLoader(System.in, System.out);
        CMSLoader script = new CMSLoader();
        script.load((ParameterReader)loader, new ErrorList());
        script.run(new ScriptContext(session, (ParameterLoader)loader));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassArrayParameter
    extends ClassParameter {
        private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$populate$cms$CMSLoader$ClassArrayParameter == null ? (class$com$arsdigita$populate$cms$CMSLoader$ClassArrayParameter = CMSLoader.class$("com.arsdigita.populate.cms.CMSLoader$ClassArrayParameter")) : class$com$arsdigita$populate$cms$CMSLoader$ClassArrayParameter));

        public ClassArrayParameter(String name) {
            super(name);
        }

        public Object doRead(ParameterReader paramReader, ErrorList errors) {
            String strParam = paramReader.read((Parameter)this, errors);
            if (strParam == null) {
                return new Class[0];
            }
            String[] classParams = StringUtils.split((String)strParam, (char)',');
            ArrayList<Class> classesList = new ArrayList<Class>(classParams.length);
            for (int i = 0; i < classParams.length; ++i) {
                Class classParam = (Class)super.unmarshal(classParams[i], errors);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("read class " + classParam));
                }
                classesList.add(classParam);
            }
            return classesList.toArray(new Class[0]);
        }

        public void doValidate(Object value, ErrorList errors) {
            Class[] classes = (Class[])value;
            for (int i = 0; i < classes.length; ++i) {
                Class classVal = classes[i];
                super.doValidate((Object)classVal, errors);
            }
            if (classes.length == 0) {
                ParameterError error = new ParameterError((Parameter)this, "At least one class must be specified");
                errors.add(error);
            }
        }

        public void doWrite(ParameterWriter writer, Object value) {
            StringBuffer sbuf = new StringBuffer();
            Class[] classes = (Class[])value;
            for (int i = 0; i < classes.length; ++i) {
                sbuf.append(super.marshal((Object)classes[i]));
                if (i == classes.length - 1) continue;
                sbuf.append(",");
            }
            writer.write((Parameter)this, sbuf.toString());
        }
    }
}

