/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.cms.FolderList;
import org.apache.log4j.Logger;

public class PopulateFolders {
    private FolderList m_folders = new FolderList();
    private String m_sBaseStringSeed = null;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$populate$cms$PopulateFolders == null ? (class$com$arsdigita$populate$cms$PopulateFolders = PopulateFolders.class$("com.arsdigita.populate.cms.PopulateFolders")) : class$com$arsdigita$populate$cms$PopulateFolders).getName());
    static /* synthetic */ Class class$com$arsdigita$populate$cms$PopulateFolders;

    public void setBaseStringSeed(String sSeed) {
        this.m_sBaseStringSeed = sSeed;
    }

    public String getBaseStringSeed() {
        return this.m_sBaseStringSeed;
    }

    public void popuate(int iFolders, ContentSection section) throws IllegalArgumentException {
        this.populate(iFolders, 1, section);
    }

    public void populate(int iTopFolders, int iFolderDepth, ContentSection section) throws IllegalArgumentException {
        if (iTopFolders < 0) {
            throw new IllegalArgumentException("Number of Top-level Folders must be >= 0");
        }
        if (iFolderDepth < 1) {
            throw new IllegalArgumentException("Depth of Folders must be >= 1");
        }
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        String sFolderDate = Utilities.getBaseString((String)this.m_sBaseStringSeed);
        for (int i = 0; i < iTopFolders; ++i) {
            txn.beginTxn();
            Folder folder = new Folder();
            folder.setContentSection(section);
            String sName = "folder" + sFolderDate + i;
            folder.setName(sName);
            folder.setLabel(sName);
            folder.setParent((ACSObject)section.getRootFolder());
            folder.save();
            this.m_folders.add(folder);
            txn.commitTxn();
            s_log.info((Object)("Created folder " + sName));
            Folder parent = folder;
            for (int j = 0; j < iFolderDepth - 1; ++j) {
                txn.beginTxn();
                Folder child = new Folder();
                child.setContentSection(section);
                sName = "folder" + sFolderDate + i + "_" + j;
                child.setName(sName);
                child.setLabel(sName);
                child.setParent((ACSObject)parent);
                child.save();
                this.m_folders.add(child);
                txn.commitTxn();
                s_log.info((Object)("Created folder " + sName));
                parent = child;
            }
        }
    }

    public FolderList getFolders() {
        return this.m_folders;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

