/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.cms.CreateContentItem;
import com.arsdigita.populate.cms.FolderList;
import org.apache.log4j.Logger;

public class PopulateContent {
    private int m_iParentIndex = 0;
    int m_iContent = 0;
    ContentSection m_section = null;
    String m_sBaseStringSeed = null;
    private final boolean m_manageTransactions;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$populate$cms$PopulateContent == null ? (class$com$arsdigita$populate$cms$PopulateContent = PopulateContent.class$("com.arsdigita.populate.cms.PopulateContent")) : class$com$arsdigita$populate$cms$PopulateContent).getName());
    static /* synthetic */ Class class$com$arsdigita$populate$cms$PopulateContent;

    public PopulateContent(int iContent, ContentSection section) throws IllegalArgumentException {
        this(iContent, section, true);
    }

    public PopulateContent(int iContent, ContentSection section, boolean manageTransactions) throws IllegalArgumentException {
        if (iContent < 0) {
            throw new IllegalArgumentException("Number of Content Items must be >= 0");
        }
        this.m_iContent = iContent;
        this.m_section = section;
        this.m_manageTransactions = manageTransactions;
    }

    public void setBaseStringSeed(String sSeed) {
        this.m_sBaseStringSeed = sSeed;
    }

    public String getBaseStringSeed() {
        return this.m_sBaseStringSeed;
    }

    public void popuate(CreateContentItem createItem, FolderList parents) {
        this.populate(createItem, parents, 0);
    }

    public void populate(CreateContentItem createItem, FolderList parents, int beginParentIndex) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        String sBase = Utilities.getBaseString((String)this.m_sBaseStringSeed);
        int iFolders = parents.size();
        for (int i = 0; i < this.m_iContent; ++i) {
            this.beginTxn();
            String sTitle = createItem.getContentTypeName() + sBase + i;
            s_log.info((Object)("Creating content item " + sTitle));
            this.m_iParentIndex = (beginParentIndex + i) % iFolders;
            Folder parent = parents.get(this.m_iParentIndex);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parent of " + sTitle + " is " + parent.getName()));
                s_log.debug((Object)("Parent folder index is " + this.m_iParentIndex));
            }
            long start = System.currentTimeMillis();
            createItem.setup(sTitle, (ContentItem)parent, this.m_section);
            long setup = PopulateContent.now() - start;
            start = PopulateContent.now();
            createItem.makeContent();
            long makeContent = PopulateContent.now() - start;
            start = PopulateContent.now();
            createItem.publish();
            long publish = PopulateContent.now() - start;
            start = PopulateContent.now();
            this.endTxn();
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("setup() " + setup + " " + "makeContent() " + makeContent + " " + "publish() " + publish + " " + "commitTxn() " + (PopulateContent.now() - start)));
        }
    }

    private void beginTxn() {
        if (this.m_manageTransactions) {
            SessionManager.getSession().getTransactionContext().beginTxn();
        }
    }

    private void endTxn() {
        if (this.m_manageTransactions) {
            SessionManager.getSession().getTransactionContext().commitTxn();
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    public int getLastFolderIndex() {
        return this.m_iParentIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

