/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ui.ContentItemPage;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;

/**
 * Class for generating a URL to the Finish Task Pane given the ID of the
 * ContentItem and the Task.
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class FinishTaskURLGenerator implements TaskURLGenerator {
    public static final String versionId = 
        "$Id: //cms/dev/src/com/arsdigita/cms/workflow/FinishTaskURLGenerator.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public static FinishTaskURLGenerator s_instance;

    public FinishTaskURLGenerator() {
        super();
    }

    public static FinishTaskURLGenerator getInstance() {
        if (s_instance == null) {
            s_instance = new FinishTaskURLGenerator();
        }

        return s_instance;
    }

    /**
     * Generates a Link to the Finish Task Panel under the Workflow Tab
     * in the Item Management part of the CMS UI.
     *
     * @param itemId a BigDecimal id of the item in question
     * @param taskId a BigDecimal id of the task to finish
     */
    public String generateURL(BigDecimal itemId, BigDecimal taskId) {
        if (itemId == null || taskId == null) {
            return "";
        }

        StringBuffer url = new StringBuffer
            (ContentItemPage.getItemURL(itemId, ContentItemPage.WORKFLOW_TAB));

        // XXX task, approve, and action were constants; restore them
        url.append("&action=finish&task=").append(taskId.toString());

        return url.toString();
    }

    public String generateURLWithReturn(BigDecimal itemId, BigDecimal taskId,
                                        PageState state) {
        final StringBuffer url = new StringBuffer(generateURL(itemId, taskId));

        try {
            url
                .append("&")
                .append(com.arsdigita.kernel.security.UserContext.RETURN_URL_PARAM_NAME)
                .append("=")
                .append(URLEncoder.encode(state.stateAsURL()));
        } catch (IOException e) {
            // Empty
        }

        return url.toString();
    }
}
