/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ui.ContentItemPage;

import java.math.BigDecimal;



/**
 * Generates a Link to the Deploy Task Panel under the Workflow Tab
 * in the Item Management part of the CMS UI.
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 * */

public class DeployTaskURLGenerator implements TaskURLGenerator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/workflow/DeployTaskURLGenerator.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public DeployTaskURLGenerator() {}

    /**
     * Generates a Link to the Finish Task Panel under the Workflow Tab
     * in the Item Management part of the CMS UI.
     *
     * @param itemId a BigDecimal id of the item in question
     * @param taskId a BigDecimal id of the task to finish
     * */
    public String generateURL(BigDecimal itemId, BigDecimal taskId) {
        String url = ContentItemPage.getItemURL(itemId, ContentItemPage.PUBLISHING_TAB);
        return url;
    }
}
