/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.workflow.simple.Workflow;
import org.apache.log4j.Logger;

/**
 * @author Uday Mathur
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowEditForm.java#5 $
 */
class WorkflowEditForm extends BaseWorkflowForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowEditForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(WorkflowEditForm.class);

    private final WorkflowRequestLocal m_workflow;

    WorkflowEditForm(final WorkflowRequestLocal workflow) {
        super("workflow", gz("cms.ui.workflow.edit"));

        m_workflow = workflow;

        addInitListener(new InitListener());
        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final Workflow workflow = m_workflow.getWorkflow(state);

            workflow.setLabel((String) m_title.getValue(state));
            workflow.setDescription((String) m_description.getValue(state));

            workflow.save();
        }
    }

    private class InitListener implements FormInitListener {
        public final void init(final FormSectionEvent e) {
            final PageState state = e.getPageState();
            final Workflow workflow = m_workflow.getWorkflow(state);

            m_title.setValue(state, workflow.getLabel());
            m_description.setValue(state, workflow.getDescription());
        }
    }
}
