/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.CMS;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.web.Web;

import java.math.BigDecimal;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowItemPane.java#12 $
 */
final class ItemWorkflowItemPane extends BaseWorkflowItemPane {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowItemPane.java#12 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final AssignedTaskTable m_assigned;

    public ItemWorkflowItemPane(final WorkflowRequestLocal workflow,
                                final ActionLink editLink,
                                final ActionLink deleteLink) {
        super(workflow, editLink, deleteLink);

        m_actionGroup.addAction(new AdminVisible(new StartLink()));
        m_actionGroup.addAction(new AdminVisible(new StopLink()));

        m_assigned = new AssignedTaskTable(workflow);
        m_detailPane.add(new AssignedTaskSection(workflow, m_assigned));

        final TaskFinishForm taskFinishForm = new TaskFinishForm
            (new TaskSelectionRequestLocal());
        add(taskFinishForm);

        connect(m_assigned, 2, taskFinishForm);
        connect(taskFinishForm);
    }

    private final class TaskSelectionRequestLocal extends TaskRequestLocal {
        protected final Object initialValue(final PageState state) {
            final String id = m_assigned.getRowSelectionModel().getSelectedKey
                (state).toString();

            return new CMSTask(new BigDecimal(id));
        }
    }

    private boolean hasAdmin(final PageState state) {
        final SecurityManager sm = CMS.getContext().getSecurityManager();

        return sm.canAccess(state.getRequest(), WORKFLOW_ADMIN);
    }

    private class StopLink extends ActionLink {
        StopLink() {
            super(new Label(gz("cms.ui.item.workflow.stop")));

            addActionListener(new Listener());
        }

        public final boolean isVisible(final PageState state) {
            final Workflow workflow = m_workflow.getWorkflow(state);
            return workflow.getProcessState() == Workflow.STARTED;
        }

        private class Listener implements ActionListener {
            public final void actionPerformed(final ActionEvent e) {
                final PageState state = e.getPageState();

                if (hasAdmin(state)) {
                    final Workflow workflow = m_workflow.getWorkflow
                        (state);

                    workflow.stop(Web.getContext().getUser());
                }
            }
        }
    }

    private class StartLink extends ActionLink {
        StartLink() {
            super(new Label(gz("cms.ui.item.workflow.start")));

            addActionListener(new Listener());
        }

        public final boolean isVisible(final PageState state) {
            final Workflow workflow = m_workflow.getWorkflow(state);

            return workflow.getProcessState() == Workflow.STOPPED;
        }

        private class Listener implements ActionListener {
            public final void actionPerformed(final ActionEvent e) {
                final PageState state = e.getPageState();

                if (hasAdmin(state)) {
                    final Workflow workflow = m_workflow.getWorkflow
                        (state);

                    workflow.start(Web.getContext().getUser());
                }
            }
        }
    }

}
