/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.globalization.GlobalizedMessage;
import org.apache.log4j.Logger;

/**
 * @author Uday Mathur
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/BaseWorkflowForm.java#5 $
 */
class BaseWorkflowForm extends BaseForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/BaseWorkflowForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(BaseWorkflowForm.class);

    final Name m_title;
    final Description m_description;

    BaseWorkflowForm(final String key, final GlobalizedMessage message) {
        super(key, message);

        m_title = new Name("name", 200, true);
        addField(gz("cms.ui.name"), m_title);

        m_description = new Description("desc", 4000, true);
        addField(gz("cms.ui.description"), m_description);

        addAction(new Finish());
        addAction(new Cancel());

        addSecurityListener(SecurityManager.WORKFLOW_ADMIN);
        addValidationListener(new ValidationListener());
    }

    private class ValidationListener implements FormValidationListener {
        public final void validate(final FormSectionEvent e)
                throws FormProcessException {
            final String name = (String) m_title.getValue(e.getPageState());

            // XXX do a dupe check here ala commented out code below
        }
    }

    /*
    protected void addValidationListener(Form f) {
        f.addValidationListener(new DataQueryExistsListener(ERROR_MSG) {
                private final String QUERY_NAME =
                    "com.arsdigita.workflow.simple.getProcessDefinitions";


                public void validate(FormSectionEvent event)
                    throws FormProcessException {

                    String name = (String) m_title.getValue(event.getPageState());
                    if ( name != null ) {
                        super.validate(event);
                    } else {
                        // Do nothing. The NotNullValidation listener should kick in.
                    }
                }

                public DataQuery getDataQuery(FormSectionEvent e) {
                    PageState s = e.getPageState();
                    Session session = SessionManager.getSession();
                    DataQuery query = session.retrieveQuery(QUERY_NAME);
                    Filter listenerFilter = query.addFilter("lower(processDefinitionLabel) = lower(:label)");
                    listenerFilter.set("label", ((String) m_title.getValue(s)).trim());
                    Filter itemFilter = query.addNotEqualsFilter
                        ("processDefinitionId", m_id.getValue(s));
                    return query;
                }
            });
    }
    */
}
